# cumvarpTopN {#cumvarptopn}

## Syntax {#syntax}

`cumvarpTopN(X, S, top, [ascending=true], [tiesMethod='latest'])`

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the population variance of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumvarpTopN(X, S, 6, 4)
// output: [0,0.25,0.6666,12.5,1484.5599,1288.3333,1282.4722]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumvarpTopN(X, S, 6, 4)
```

|\#1|\#2|
|---|---|
|0||
|0.25|0|
|0.6667|0.25|
|0.6667|0.6667|
|2.1875|0.6667|
|3.44|2.1875|
|4.6667|3.44|
|5.6667|4.6667|
|5.6667|6.4722|
|5.6667|7.6667|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumvarpTopN(price, id, 6, 4) as result from t
```

|result|
|------|
|0|
|182.25|
|124.2222|
|114.5|
|255.44|
|428.4722|
|428.4722|
|416.9167|
|722.9167|
|722.9167|

