# cumstdTopN {#cumstdtopn}

## Syntax {#syntax}

`cumstdTopN(X, S, top, [ascending=true], [tiesMethod='latest'])`

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the unbiased sample standard deviation of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumstdTopN(X, S, 6, 4)
// output: [,0.70,1,4.08,43.07,39.31,39.22]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumstdTopN(X, S, 6, 4)
```

|\#0|\#1|
|---|---|
|||
|0.7071||
|1|0.7071|
|1|1|
|1.7078|1|
|2.0736|1.7078|
|2.3664|2.0736|
|2.6077|2.3664|
|2.6077|2.7869|
|2.6077|3.0332|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumavgTopN(price, id, 6, 4) as result from t
```

|result|
|------|
|94|
|69.5|
|46.3333|
|55.75|
|57.8|
|49.6667|
|50.5|
|50.5|
|51.5|
|51.5|

