# cumstd {#cumstd}

## Syntax {#syntax}

`cumstd(X)`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Details {#details}

Cumulatively calculate the standard deviation of *X*.

## Examples {#examples}

```
x = [1,2,4,NULL,8];
cumstd(x);
// output: [,0.707107,1.527525,1.527525,3.095696]

m=matrix(0.15 0.08 0.03 -0.14 -0.09, 0.2 -0.12 -0.16 0.08 0.16);
m;
```

|\#0|\#1|
|---|---|
|0.15|0.2|
|0.08|-0.12|
|0.03|-0.16|
|-0.14|0.08|
|-0.09|0.16|

```
cumstd(m);
```

|\#0|\#1|
|---|---|
| | |
|0.049497474683058|0.226274169979695|
|0.060277137733417|0.19731531449265|
|0.123558353285671|0.169705627484771|
|0.119707978013163|0.16346253393362|

Related functions: [std](../s/std.md)

