# cumskewTopN {#cumskewtopn}

## Syntax {#syntax}

`cumskewTopN(X, S, top, [biased=true], [ascending=true], [tiesMethod='latest'])`

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the moving skewness of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumskewTopN(X, S, 6, 4)
// output: [,0,0,1.0182,1.4754,1.7635,1.7650]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumskewTopN(X, S, 6, 4)
```

|\#0|\#1|
|---|---|
|||
|0||
|0|0|
|0|0|
|0.4373|0|
|0.158|0.4347|
|0|0.158|
|-0.4448|0|
|-0.4448|-0.3599|
|-0.4448|-0.1413|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumskewTopN(price, id, 6, 4) as result from t
```

|result|
|------|
||
|0|
|-0.6435|
|-0.7353|
|-0.209|
|-0.2864|
|-0.0042|
|0.0955|
|0.0955|
|-0.5659|

