# cumpercentile {#cumpercentile}

## Syntax {#syntax}

`cumpercentile(X, percent, [interpolation='linear'])`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Arguments {#arguments}

**X** is a vector or matrix.

**percent** is an integer or a floating point number between 0 and 100.

**interpolation** \(optional\) is a string indicating the interpolation method to use if the specified percentile is between two elements in *X* \(assuming the i-th and \(i+1\)-th element in the sorted *X*\) . It can take the following values:

-   'linear': Return X\(i\)+\(X\(t+1\)-X\(t\)\)\*fraction, where fraction = \(\(percentile100\)-\(i\(size-1\)\)\)\(1\(size-1\)\)

-   'lower': Return X\(i\)

-   'higher': Return X\(i+1\)

-   'nearest': Return X\(i\) or X\(i+1\) that is closest to the specified percentile

-   'midpoint': Return \(X\(i\)+X\(i+1\)\)2


The default value of interpolation is 'linear'.

## Details {#details}

-   If *X* is a vector, cumulatively calculate the given percentile of a vector. The calculation ignores null values.
-   If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a matrix with the same shape as *X*.

## Examples {#examples}

```
a=1..10;

cumpercentile(a,25);
// output: [1,1.25,1.5,1.75,2,2.25,2.5,2.75,3,3.25]

cumpercentile(a,25,'lower');
// output: [1,1,1,1,2,2,2,2,3,3]

cumpercentile(a,25,'higher');
// output: [1,2,2,2,2,3,3,3,3,4]

cumpercentile(a,25,'midpoint');
// output: [1,1.5,1.5,1.5,2,2.5,2.5,2.5,3,3.5]

cumpercentile(a,25,'nearest');
// output: [1,1,1,2,2,2,2,3,3,3]

cumpercentile(a,50.5);
// output: [1,1.505,2.01,2.515,3.02,3.525,4.03,4.535,5.04,5.545]

m=matrix(1..10, 11..20);
m;
```

|\#0|\#1|
|---|---|
|1|11|
|2|12|
|3|13|
|4|14|
|5|15|
|6|16|
|7|17|
|8|18|
|9|19|
|10|20|

```
cumpercentile(m,25);
```

|\#0|\#1|
|---|---|
|1|11|
|1.25|11.25|
|1.5|11.5|
|1.75|11.75|
|2|12|
|2.25|12.25|
|2.5|12.5|
|2.75|12.75|
|3|13|
|3.25|13.25|

Related functions: [percentile](../p/percentile.md)

