# cumnunique {#cumnunique}

## Syntax {#syntax .section}

`cumnunique(X, [ignoreNull=false])`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Arguments {#Arguments .section}

**ignoreNull** \(optional\) is a Boolean value. If set to true, only non-null elements will be included in the calculation. The default value is false.

## Details {#details .section}

Return the cumulative count of unique elements in *X*.

**Note:** Null values are included in the calculation.

## Examples {#examples .section}

```
v = [NULL, 1, 2, -6, 0, 1, 2]
cumnunique(v)
// output: [1,2,3,4,5,5,5]

t = table(`a`a`b`c`a`b as id, 20 20 10 40 30 20 as val)
select cumnunique(id) as cumVal from t
```

|cumVal|
|------|
|1|
|1|
|2|
|3|
|3|
|3|

