# cumavgTopN {#cumavgtopn}

## Syntax {#syntax}

`cumavgTopN(X, S, top, [ascending=true], [tiesMethod='latest'])`

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the average of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumavgTopN(X, S, 6, 4)
// output: [1,1.5,2,4,23.199,20,20.167]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumavgTopN(X, S, 6, 4)
```

|\#0|\#1|
|---|---|
|1||
|1.5|12|
|2|12.5|
|2|13|
|2.75|13|
|3.4|13.75|
|4|14.4|
|5|15|
|5|15.8333|
|5|16|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumavgTopN(price, id, 6, 4) as result from t
```

|result|
|------|
|94|
|69.5|
|46.3333|
|55.75|
|57.8|
|49.6667|
|50.5|
|50.5|
|51.5|
|51.5|

