# cubicSplinePredict {#cubicsplinepredict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cubicSplinePredict(model, x)`

## Arguments {#arguments}

**model** is a dictionary with two keys, c and x. The value of c is the coefficients of the polynomials on each segment, and the value of x is the polynomial breakpoints. The length of c is equal to `(the length of x -1)*4`. Neither c nor x can contain null values. The model can be obtained with function `cubicSpline`.

**x** is a numeric scalar or vector containing the independent variable to be predicted.

## Details {#details}

Predict the corresponding y for x with the given model.

## Examples {#examples}

``` {#codeblock_ytk_rx3_21c}
n = 10
x = 0..(n-1)
y = sin(x)
model = cubicSpline(x, y, bc_type="not-a-knot")

newx = [-0.5, 0.5, 0.7, 1.2, 4.5, 8.9, 9.3]
ret = cubicSplinePredict(model, newx)

// output: [-0.632383304169291,0.501747281896522,0.658837295715183,0.924963051153032,-0.974025627606784,0.515113155358425,0.03881591118089]
```

Related Function: [cubicSpline](cubicspline.md)

