# createStreamGraph {#createStreamGraph}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`createStreamGraph(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Creates a declarative stream graph. It supports the following capabilities:

-   **Lifecycle management**: Initialize, execute, and terminate the stream graph.
-   **Configuration**: Set parameters for subscriptions and private stream tables.
-   **Data source definition**: Define sources including persisted stream tables, high-availability stream tables, and streaming engines.

**Return value**: A StreamGraph object.

## Examples {#examples}

Create a stream graph named “indicators”.

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("orca")) {
	createCatalog("orca")
}
go
use catalog orca

g = createStreamGraph("indicators") 
```

**Related functions:**[dropStreamGraph](../d/dropStreamGraph.md), [startStreamGraph](../s/startStreamGraph.md), [stopStreamGraph](../s/stopStreamGraph.md), [StreamGraph::dropGraph](../s/StreamGraph_dropGraph.md)

