# createDeviceEngine {#createDeviceEngine}

**Note:** This function is not supported by Community Edition. You can [get a trial](https://dolphindb.com/product#downloads-down) of Shark from DolphinDB official website.

## Syntax {#Syntax .section}

`createDeviceEngine(name, metrics, dummyTable, outputTable, [keyColumn],[keepOrder])`

## Arguments {#Arguments .section}

**name** is a string of the engine name. It is the only identifier of a reactive state engine on a data/compute node. It can have letter, number and "\_" and must start with a letter.

**metrics** is metacode specifying the formulas for calculation. It can include one or more expressions, built-in functions, or user-defined functions. User-defined functions must have a single return value and must not contain embedded for loops or any loops that exceed 100 iterations. It can also include a constant or a vector of constants \(in which case, the output column must be of the array vector type\). For more information about metacode, refer to [Metaprogramming](../../Programming/Metaprogramming/functional_meta.md).

**dummyTable** is a table object whose schema must be the same as the subscribed stream table. Whether *dummyTable* contains data does not matter.

**outputTable** is the output table for the results. It can be an in-memory table or a DFS table. Create an empty table and specify the column names and types before calling the function.

**keyColumn** \(optional\) is a STRING scalar/vector indicating the grouping column\(s\).

**keepOrder** \(optional\) specifies whether to preserve the insertion order of the records in the output table. The default value is false, meaning data is sorted by *keyColumn*.

## Details {#Details .section}

Create a device engine which conducts the calculations defined in the *metrics*with GPU acceleration.

**Note:** The device engine does not retain any state information from one batch of data to the next. In other words, when two batches are processed, the second batch is processed independently of the first batch.

The following functions can be accelerated using GPUs:

-   Basic unary operation: not, neg, cast, log, log2, log10 ,log1p ,abs, sign, sqrt, sin, sinh, asin, asinh, cos, cosh, acos, acosh, tan, tanh, atan, atanh, reciprocal, cbrt, exp, exp2, expm1

-   Basic binary operation: add, sub, mul, div, ratio, pow, lt, gt, le, ge, eq, ne, and, or, or\_\_, max, min

-   Binary operation on integers: mod, bitAnd, bitOr, bitXor, lshift, rshift

-   Ternary operation: iif

-   Unary moving functions: mavg, msum, mcount, mprod, mvar, mvarp, mstd, mstdp, mskew, mkurtosis, mmin, mmax, mimin, mimax, sma, wma, mfirst, mlast, mrank, mmaxPositiveStreak, mmed, mpercentile, mmad \(*useMedian* is currently not supported\)

-   TALib-series Unary moving functions: sma, ema, wma, dema, tema, trima, t3, wilder, gema, linearTimeTrend, ma, talib \(only the `m-` /moving functions and `mTopN-`/moving TopN functions are accepted\)

-   Binary moving functions: mcorr, mbeta, mcovar, mwsum, mwavg

-   Other moving functions: linearTimeTrend, mslr

-   Unary cumulative functions: cumsum, cumprod, cummin, cummax, cumvar, cumvarp, cumstd, cumstdp, cumnunique, cumfirstNot, cumlastNot, cumavg, cumcount, cumPositiveStreak

-   Binary cumulative functions: cumcorr, cumcovar, cumbeta, cumwsum, cumwavg

-   Order-sensitive functions: deltas, ratios, ffill, move, prev, next, percentChange, iterate, prevState, ewmMean, ewmVar, ewmStd, ewmCov, ewmCorr

    **Note:** For `ewmVar`, `ewmStd`, `ewmCov`, and `ewmCorr`, the *adjust* parameter must be set to false and *bias*must be true.

-   Moving TopN functions: msumTopN, mavgTopN, mstdpTopN, mstdTopN, mvarTopN, mvarpTopN, mwsumTopN, mcorrTopN, mcovarTopN, mbetaTopN, mskewTopN, mkurtosisTopN

-   Row-based functions: rowMin, rowMax, rowAnd, rowOr, rowXor, rowProd, rowSum, rowSum2, rowSize, rowCount, rowAvg, rowVar, rowVarp, rowStd, rowStdp

-   Time-based moving functions: tmsum, tmsum2, tmavg, tmprod, tmcount, tmvar, tmvarp, tmstd, tmstdp, tmcovar, tmcorr, tmwavg, tmwsum, tmbeta, tmfirst, tmlast, tmmin, tmmax, tmskew, tmkurtosis, tmove

-   Other functions: TrueRange, topRange, lowRange, stateMavg


**Note:** Starting from version 3.00.1, when the absolute value of a calculation result is less than DBL\_EPSILON\*10000 *\(approximately 2.22\**10^-12\), all moving functions and cumulative window functions will retain full precision instead of rounding the result.

## Details {#Details.1 .section}

``` {#codeblock_xjl_vzp_3bc}
// create a device engine
dummyTb = table(1:0, `sym`id`value, [SYMBOL,INT,DOUBLE])
share table(100:0, `sym`id`flag`value`factor, [SYMBOL,INT,SYMBOL,DOUBLE,DOUBLE]) as result
de = createDeviceEngine(name="myDe", metrics=[<id>,<"flag"+"_A">,<value>,<mavg(value,5)>], dummyTable=dummyTb, outputTable=result, keyColumn="sym")


// simulate data
data1 = table(take("A", 100) as sym, 1..100 as id, double(10+1..100) as value)
data2 = table(take("B", 100) as sym, 1..100 as id, double(20+1..100) as value)
data3 = table(take("C", 100) as sym, 1..100 as id, double(30+1..100) as value)
data = data1.unionAll(data2).unionAll(data3).sortBy!(`id)

// write data
de.append!(data)
select top 10 * from result
```

|sym|id|flag|value|factor|
|---|---|----|-----|------|
|A|1|flag\_A|11||
|A|2|flag\_A|12||
|A|3|flag\_A|13||
|A|4|flag\_A|14||
|A|5|flag\_A|15|13|
|A|6|flag\_A|16|14|
|A|7|flag\_A|17|15|
|A|8|flag\_A|18|16|
|A|9|flag\_A|19|17|
|A|10|flag\_A|20|18|

