# covarMatrix {#covarmatrix}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`covarMatrix(X)`

## Arguments {#arguments}

**X** is a matrix.

## Details {#details}

Return a covariance matrix, where the \(i, j\) entry is the covariance between the columns *i* and *j* of *X*.

Note:

-   For a matrix *X* without null values, the result of `covarMatrix(X)` is equivalent to `cross/pcross(covar, X)`, but the performance of function covarMatrix is significantly improved.

-   For a matrix with null values, the results of `covarMatrix(X)` and `cross/pcross(covar, X)` are different, because the null values are converted to 0 by default in function `covarMatrix`, but ignored in function `covar`.


## Examples {#examples}

```
m = rand(10.0, 30)$10:3
covarMatrix(m)
```

|\#0|\#1|\#2|
|---|---|---|
|6.116181845352529|1.107026927999891|1.306707566911273|
|1.107026927999891|7.162534080771522|-0.758517799304199|
|1.306707566911273|-0.758517799304199|5.516744365930221|

```
a = rand(1.0, 30000000).reshape(10000:3000)
a.rename!("s" + string(1..3000))

timer covarMatrix(a)
// Time elapsed: 2927.264 ms

timer pcross(covar, a)
// Time elapsed: 29484.85 ms
```

Related function: [corrMatrix](corrMatrix.md)

