# count {#count}

## Syntax {#syntax}

`count(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

[size](../s/size.md) returns the number of elements in a vector or matrix, while `count` returns the number of non-null elements in a vector/matrix. `count` can be used in a SQL query, but `size` cannot. For tables, `size` and `count` both return the number of rows.

## Examples {#examples}

```
count(3 NULL 5 6);
// output: 3
size(3 NULL 5 6);
// output: 4

m=1 2 3 NULL 4 5$2:3;
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|4|
|2||5|

```
count(m);
// output: 5
size(m);
// output: 6

t = table(1 NULL 3 as id, 3 NULL 9 as qty);
t;
```

|id|qty|
|---|---|
|1|3|
|||
|3|9|

```
count(t);
// output: 3
size(t);
// output: 3
```

