# corrMatrix {#corrmatrix}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`corrMatrix(X)`

## Arguments {#arguments}

**X** is a matrix.

## Details {#details}

Return a correlation matrix, where the \(i, j\) entry is the correlation between the columns *i* and *j* of *X*.

Note:

-   For a matrix *X* without null values, the result of `corrMatrix(X)` is equivalent to `cross/pcross(corr, X)`, but the performance of function corrMatrix is significantly improved.

-   For a matrix with null values, the results of `corrMatrix(X)` and `cross/pcross(corr, X)` are different, because the null values are converted to 0 by default in function `corrMatrix`, but ignored in function `corr`.


## Examples {#examples}

```
m = rand(10.0, 30)$10:3
corrMatrix(m)
```

|\#0|\#1|\#2|
|---|---|---|
|1|0.167257129736134|0.224955585716037|
|0.167257129736134|1|-0.12066768907057|
|0.224955585716037|-0.12066768907057|1|

```
a = rand(1.0, 30000000).reshape(10000:3000)
a.rename!("s" + string(1..3000))

timer corrMatrix(a)
// Time elapsed: 2986.932 ms

timer pcross(corr, a)
// Time elapsed: 45629.6 ms
```

Related function: [covarMatrix](covarMatrix.md)

