# copyReplicas {#copyreplicas}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`copyReplicas(srcNode, destNode, chunkId)`

## Arguments {#arguments}

**srcNode** is a string indicating the alias of origination node.

**destNode** is a string indicating the alias of destination node.

**chunkId** is a STRING scalar or vector indicating ID of chunk\(s\).

## Details {#details}

Copy replicas of one or multiple chunks from a node to another node. If the destination node already has the chunk, the command is skipped.

This command can only be executed by an administrator on a controller node.

You can check the execution status with function [getRecoveryTaskStatus](../g/getRecoveryTaskStatus.md) .

## Examples {#examples}

Copy replicas of all chunks on "node1" to "node2".

```
chunkIds=exec chunkId from pnodeRun(getAllChunks) where node="node1"
copyReplicas("node1","node2",string(chunkIds));
```

