# convertibleFixedRateBondDirtyPrice {#convertiblefixedratebonddirtyprice}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`convertibleFixedRateBondDirtyPrice(settlement, issue, maturity, redemption, coupon, spread, riskFree, volatility, spot, conversionPrice, divYield, divDates, callDates, callPrices, putDates, putPrices, style, calendar, frequency, [basis=1], [convention='Following'], [method='binomial'], [kwargs])`

## Details {#details}

Calculate the price of the convertible bonds, including interest, for every 100 of face value.

Convertible bond is a type of bond that the holder can convert into a specified number of shares of common stock in the issuing company or cash of equal value. It is a hybrid security with debt- and equity-like features. Convertible bonds often include embedded rights for bond redemption or put options.

**Return value:** A scalar or vector of type DOUBLE.

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length. For array vector inputs, the number of rows must match the length of the other vectors.

**settlement** is a DATE scalar or vector indicating the settlement date.

**issue** is a DATE scalar or vector indicating the issuance date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**redemption** is a numeric scalar or vector indicating the redemption value.

**coupon** is a numeric scalar or vector indicating the annual coupon rate. For example, 0.03 indicates a 3% annual coupon.

**spread** is a numeric scalar or vector indicating the interest rate spread.

**riskFree** is a numeric scalar or vector indicating the risk-free interest rate.

**volatility** is a numeric scalar or vector indicating the volatility.

**spot** is a numeric scalar or vector that represents the current price of the issuing company's stock.

**conversionPrice**is a numeric scalar or vector that represents the conversion price, i.e., the price per share to be paid when the bond is converted into stock. It determines the number of shares that can be obtained for each convertible bond.

**divYield** is a numeric scalar or vector that represents the dividend yield.

**divDates**is a DATE vector or array vector that represents the dividend dates.

**callDates**is a DATE vector or array vector that represents the dates for the early redemption of the bond, as specified by the embedded call option.

**callPrices**is a numeric vector or array vector that represents the redemption prices for the bond on the call dates specified by the embedded call option. It must correspond directly to the *callDates*.

**putDates**is a DATE vector or array vector that represents the dates for the early put \(sale\) of the bond, as specified by the embedded put option.

**putPrices** is a numeric vector or array vector that represents the prices at which the bond can be sold back \(put\) early, as specified by the embedded put option. It must correspond directly to the *putDates*.

**style** is a STRING scalar or vector indicating the option exercise style. It can be 'european' or 'american'.

**calendar** is a STRING scalar or vector indicating the trading calendar\(s\). See [Trading Calendar](../../Tutorials/trading_calendar.md) for more information.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**convention** \(optional\) is a STRING scalar or vector indicating how cash flows that fall on a non-trading day are treated. The following options are available. Defaults to 'Following'.

-   'Following': The following trading day.
-   'ModifiedFollowing': The following trading day. If that day is in a different month, the preceding trading day is adopted instead.
-   'Preceding': The preceding trading day.
-   'ModifiedPreceding': The preceding trading day. If that day is in a different month, the following trading day is adopted instead.
-   'Unadjusted': Unadjusted.
-   'HalfMonthModifiedFollowing': The following trading day. If that day crosses the mid-month \(15th\) or the end of month, the preceding trading day is adopted instead.
-   'Nearest': The nearest trading day. If both the preceding and following trading days are equally far away, default to following trading day.

**method** \(optional\) is a STRING scalar indicating the valuation method used. Currently, only "binomial" is supported, which means the valuation is performed using the Binomial tree model.

**kwargs** \(optional\) is a dictionary specifying other parameters required by the valuation method. When *method*='binomial', the key-values pairs should be:

-   'type': A STRING scalar or vector that specifies the type of the binomial tree model. The possible values are:
    -   'crr' \(default\): Cox-Ross-Rubinstein model
    -   'jr': Jarrow-Rudd model
-   'timeSteps': An INT scalar or vector that represents the number of time steps in the binomial tree model. The default value is 100.

## Examples {#examples}

Consider a 5-year convertible bond A issued on August 28, 2023, with a maturity date of August 28, 2028, and a trade date of August 28, 2024. The bond has a redemption price of 100, an annual coupon rate of 0.05, and pays interest annually with a spread of 0.005. The conversion price is 26, and the current stock price is 36. The dividend yield is 0.02, with dividends paid every 6 months starting from October 28, 2024, for a total of 6 payments.

The bond can be redeemed at prices of 101.5 on August 28, 2025, and 100.85 on August 30, 2027. It can also be put back at 105 on August 28, 2026. The market's risk-free interest rate is 0.06, with a volatility of 0.2. The day count convention is Actual/365, and the method for adjusting non-business days is modified following, following the NewYork Stock Exchange \(XNYS\) calendar.

Calculate the price of the bond, including interest, for both European and American exercise options.

``` {#codeblock_eqy_3kn_c2c}
spot = 36.0
conversionPrice = 26.0
redemption = 100
spread = 0.005
divYield = 0.02
riskFree = 0.06
volatility = 0.20
issue = 2023.08.28
settlement = 2024.08.28
maturity = 2028.08.28
convention = `ModifiedFollowing
calendar = `XNYS
style = [`european, `american]
frequency = 1
coupon = 0.05
basis = 3
divFreq = 6M
nextDivDate = 2024.10.28
divDates = []
for (i in 0..5) {
	divDates.append!(nextDivDate)
	nextDivDate = temporalAdd(nextDivDate, divFreq)
}
divDates = divDates$DATE
callDates = [2025.08.28, 2027.08.30]
callPrices = [101.5, 100.85]
putDates = [2026.08.28]
putPrices = [105.0]
convertibleFixedRateBondDirtyPrice(settlement, issue, maturity, redemption, coupon, spread, riskFree,
                             volatility, spot, conversionPrice, divYield, divDates, callDates,
                            callPrices, putDates, putPrices, style, calendar, frequency, basis, convention)
// [100.14675326378128,138.45755887077215]
```

