# constantDesc {#constantDesc}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`constantDesc(obj)`

## Arguments {#arguments}

**obj** is an object.

## Details {#details}

This function provides a description of an object.

Return value: A dictionary with the following keys:

|Key|Description|
|---|-----------|
|form|the data form|
|vectorType|the specific vector type, returns only when *obj* is a vector|
|isIndexedMatrix|whether it is an indexed matrix, returns only when *obj* is a matrix|
|isIndexedSeries|whether it is an indexed series, returns only when *obj* is a matrix|
|nullFlag|whether it contains null values, returns only when *obj* is a vector, pair, or matrix|
|isView|whether it is a view, returns only when *obj* is a vector, pair, or matrix|
|tableType|the specific table type, returns only when *obj* is a table|
|type|the data type|
|codeType|the specific metacode type, returns only when *obj* is metacode|
|functionDefType|the specific function type, returns only when *obj* is a function|
|scale|the number of decimal places, returns only when *obj* is of DECIMAL type|
|isColumnarTuple|whether it is a columnar tuple, returns only when *obj* is a tuple, excluding any view representations|
|category|the data type category|
|isTemporary|whether it is a temporary object|
|isIndependent|whether it is an independent object|
|isReadonly|whether it is a read-only object|
|isReadonlyArgument|whether it is a read-only argument|
|isStatic|whether it is a static object|
|isTransient|whether it is a transient object|
|copyOnWrite|whether it employs copy-on-write behavior|
|refCount|the count that has been referenced|
|address|the hexadecimal address|
|rows|the row count|
|columns|the column count|
|memoryAllocated|the memory allocated|

## Examples {#examples}

``` {#codeblock_rkl_mmx_ddc}
t = table(1..3 as id, 4..6 as val)
constantDesc(t)
/*
form->TABLE
tableType->BASIC
type->DICTIONARY
category->MIXED
isTemporary->false
isIndependent->true
isReadonly->false
isReadonlyArgument->false
isStatic->false
isTransient->false
copyOnWrite->false
refCount->1
address->0000000028d2d1e0
rows->3
columns->2
memoryAllocated->208
*/


constantDesc(lj)
/*
form->SCALAR
type->FUNCTIONDEF
functionDefType->SYSTEM FUNCTION
category->SYSTEM
isTemporary->true
isIndependent->true
isReadonly->false
isReadonlyArgument->false
isStatic->false
isTransient->false
copyOnWrite->false
refCount->6
address->000000000cabce00
rows->1
columns->1
memoryAllocated->10
*/
```

