# conditionalFilter {#conditionalfilter}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`conditionalFilter(X, condition, filterMap)`

## Arguments {#arguments}

**X** is a scalar/vector.

**condition** is a scalar or a vector of the same length as *X*.

**filterMap** is a dictionary indicating the filtering conditions.

## Details {#details}

Return true if both of the following conditions are satisfied, otherwise return false.

-   An element in the vector condition is a key to the dictionary *filterMap*;

-   The corresponding element in *X* is one of the elements of the key's value in the dictionary *filterMap*.


If both *X* and *condition* are vectors, the result is a vector of the same length as X.

## Examples {#examples}

Example 1

```
conditionalFilter(1 2 3,`a`b`c, dict(`a`b,1 2));
// output: [1,1,0]

conditionalFilter(1 2 3,`a`b`b, dict(`a`b,[1 2,3 4]))
// output: [1,0,1]
```

Example 2. Get the specified stock data of the specified dates from table t:

2012.06.01: C, MS 2012.06.02: IBM, MS 2012.06.03: MS 2012.06.04: IBM

```
sym = `C`MS`MS`MS`IBM`IBM`C`C`C$SYMBOL
date = 2012.06.01 2012.06.01 2012.06.02 2012.06.03 2012.06.01 2012.06.02 2012.06.02 2012.06.03 2012.06.04
price = 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
t = table(sym, date, price, qty)
t;
```

|sym|date|price|qty|
|---|----|-----|---|
|C|2012.06.01|49.60|2200|
|MS|2012.06.01|29.46|1900|
|MS|2012.06.02|29.52|2100|
|MS|2012.06.03|30.02|3200|
|IBM|2012.06.01|174.97|6800|
|IBM|2012.06.02|175.23|5400|
|C|2012.06.02|50.76|1300|
|C|2012.06.03|50.32|2500|
|C|2012.06.04|51.29|8800|

```
filter = dict(2012.06.01..2012.06.04, [`C`MS, `IBM`MS, `MS, `IBM])
select * from t where conditionalFilter(sym, date, filter) order by date, sym;
```

|sym|date|price|qty|
|---|----|-----|---|
|C|2012.06.01|49.6|2200|
|MS|2012.06.01|29.46|1900|
|IBM|2012.06.02|175.23|5400|
|MS|2012.06.02|29.52|2100|
|MS|2012.06.03|30.02|3200|

Example 3. The values of *filterMap* can also be pairs:

```
t=table(`aaa`aaa`bbb`bbb as id, 2020.09.03 2020.09.10 2020.09.06 2020.09.09 as date)
t
```

|id|date|
|---|----|
|aaa|2020.09.03|
|aaa|2020.09.10|
|bbb|2020.09.06|
|bbb|2020.09.09|

```
mydict = dict(`aaa`bbb, [2020.09.01 : 2020.09.09,  2020.09.05 : 2020.09.09])
select * from t where conditionalFilter(date, id, mydict);
```

|id|date|
|---|----|
|aaa|2020.09.03|
|bbb|2020.09.06|
|bbb|2020.09.09|

