# compose {#compose}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`compose(first, second)`

## Arguments {#arguments}

**first**indicates the first function to be called, which accepts one or more arguments.

**second**indicates the second function to be called, which accepts only one argument \(the return value of *first*\).

## Details {#details}

The `compose` function creates a composite function from two functions, equivalent to `second(first())`. The logic works as follows:

1.  Call the *first*function with all the provided arguments.

2.  Take the result from *first*and pass it as the only argument to the *second*function.

3.  Return the result of `second(first(...))`.


For example, for the composite function `f = compose(add, sin)`, `f(x, y)` will return the same result as `sin(add(x, y))`.

**Return value:** A new function \(of type FUNCTIONDEF\) is returned, with the same parameters as the *first*function.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
g = def(x, y, z) { return x * y + z }
f = def(x) { return abs(x * 3) }
compo_func = compose(g, f) // Equivalent to f(g(*))

compo_func(-1, 5, 3) // Output: 6
```

