# columnNames {#columnnames}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`columnNames(X)`

## Arguments {#arguments}

**X** is a matrix/table.

## Details {#details}

Return the column names of *X* as a vector. Please check related function: [rowNames](../r/rowNames.md).

## Examples {#examples}

```
x=1..6$2:3;
x;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
x.rename!(`a`b`c);
```

|a|b|c|
|---|---|---|
|1|3|5|
|2|4|6|

```
x.columnNames();
// output: ["a","b","c"]

t = table(1 2 3 as id, 4 5 6 as value, `IBM`MSFT`GOOG as name);
t;
```

|id|value|name|
|---|-----|----|
|1|4|IBM|
|2|5|MSFT|
|3|6|GOOG|

```
columnNames t;
// output: ["id","value","name"]

t[t.columnNames().tail()];
// output: ["IBM","MSFT","GOOG"] // retrieve the last column of a table as a vector
```

