# col {#col}

## Syntax {#syntax}

`col(obj, index)`

or

`column(obj, index)`

## Arguments {#arguments}

**obj** is a vector/matrix/table.

**index** is an integral scalar or pair.

## Details {#details}

Return one or more columns of a vector/matrix/table. Please check related function: [row](../r/row.md).

## Examples {#examples}

```
x=1..6$3:2;
x;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
col(x,0);
// output: [1,2,3]

x.col(1);
// output: [4,5,6]

a=table(1..3 as x,`IBM`C`AAPL as y);
a;
```

|x|y|
|---|---|
|1|IBM|
|2|C|
|3|AAPL|

```
a col 1;
// output: ["IBM","C","AAPL"]

col(a, 0:2)
```

|x|y|
|---|---|
|1|IBM|
|2|C|
|3|AAPL|

