# coint {#coint}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`coint(Y0, Y1, [trend="c"], [method="aeg"], [maxLag], [autoLag="aic"])`

## Arguments {#arguments}

**Y0**is a numeric vector indicating the first element in cointegrated system. Null values are not supported.

**Y1**is a numeric vector or matrix indicating the remaining elements in cointegrated system. The number of elements in Y1 and Y0 must be equal. Null values are not supported.

**trend**is a scalar specifying the trend term included in regression for cointegrating equation. It can be

-   "c" : constant.

-   "ct" : constant and linear trend.

-   "ctt" : constant, and linear and quadratic trend.

-   "n" : no constant, no trend.


**method** is a string indicating the method for cointegration testing. Only "aeg" \(augmented Engle-Granger\) is available.

**maxLag** is a non-negative integer indicating the largest number of lags, which is used as an argument for `adfuller`.

**autoLag** is a string indicating the lag selection criterion, which is used as an argument for `adfuller`. It can be:

-   "aic": The number of lags is chosen to minimize the Akaike information criterion.

-   "bic": The number of lags is chosen to minimize the Bayesian information criterion.

-   "tstat": Start with *maxLag* and drops a lag until the t-statistic on the last lag length is significant using a 5%-sized test.

-   "max": The number of included lags is set to *maxLag*.


## Details {#details}

Test for no-cointegration of a univariate equation.

**Return value**: A dictionary containing the following keys

-   tStat: A floating-point scalar indicating the t-statistic of unit-root test on residuals.

-   pValue: A floating-point scalar indicating the MacKinnon's approximate p-value based on MacKinnon \(1994, 2010\).

-   criticalValues: A dictionary containing the critical values for the test statistic at the 1 %, 5 %, and 10 % levels based on regression curve.


## Examples {#examples}

``` {#codeblock_dgj_xf3_31c}
Y0 = 234 267 289 301 312 323 334 345 356;
Y1 = 267 289 301 312 323 334 345 356 367;
coint(Y0, Y1);
```

A dictionary is returned:

``` {#codeblock_w3g_yf3_31c}
tValue->-1.498236972489574
pValue->0.761867238199341
criticalValues->[-5.789286875000001,-4.206501875,-3.6171]
```

