# clip {#clip}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`clip(X,Y,Z)`

## Arguments {#arguments}

**X** is a numeric or temporal scalar/vector/matrix/table, or a dictionary with numeric or temporal values.

**Y** is a numeric or temporal scalar/vector/matrix/table indicating the lower bound for the clipping range.

**Z** is a numeric or temporal scalar/vector/matrix/table indicating the upper bound for the clipping range.

**Data Type Requirements:**

-   If *X* is INTEGRAL, *Y* and *Z* must be INTEGRAL.
-   If *X* is FLOATING or DECIMAL, *Y* and *Z* can be INTEGRAL, FLOATING or DECIMAL.
-   If *X* is TEMPORAL, *Y* and *Z* must be the same TEMPORAL type.

**Data Form Requirements:**

-   If *X* is a scalar or dictionary, *Y* and *Z* must be scalars.
-   If *X* is a vector, *Y* and *Z* can be scalars, or vectors of the same length as *X*.
-   If *X* is a matrix, *Y* and *Z* can be scalars, or matrices of the same dimension as *X*.
-   If *X* is a table, *Y* and *Z* can be scalars, or tables of the same dimension as *X*.

## Details {#details}

Clips *X* to specified range.

**Return value**: *X'* of the same data type and form as *X*.

The following rules determine how *X* is clipped \(If *X* is a dictionary, "element" indicates the dictionary value\):

-   When *Y* and *Z* are scalars, the clipping range is \[*Y, Z*\]. Values outside this range are clipped to the nearest boundary.
    -   Null *Y* or *Z* indicates no limit on the lower or upper bound.
    -   If *Y* is greater than *Z*, all elements in *X'*are*Z*.
-   When *Y* and *Z* are vectors, matrices, or tables, each element*Xi* is clipped within the range \[*Yi, Zi*\]. Note: If any element in *Y* or *Z* is null, the corresponding element in *X'* is also null.
-   When *Y* or *Z* is a scalar, and the other is a vector, matrix, or table, each element *Xi* is clipped within the range *\[Y,Zi\]* or *\[Yi,Z\].*
    -   The scalar represents a fixed boundary for all elements in *X*, while vector/matrix/table specify the boundary limits for *Xi* in the corresponding position.
    -   If the scalar is null, no limit is set on the boundary. If any element in the vector, matrix or table is null, the corresponding element in *X'* is also null.
    -   If *Y* is greater than *Z* for a specific position, the corresponding element in *X'* is set to *Z*.

If *X* is a matrix or table, the aforementioned calculations will be performed on each column.

## Examples {#examples}

Example 1. When *Y* and *Z* are scalars.

Set upper bound to 5:

``` {#codeblock_kjk_hny_gdc}
X = table(1..10 as val1, 10..1 as val2)
Y = NULL // NULL means no limit
Z = 5

clip(X,Y,Z)
```

|val1|val2|
|----|----|
|1|5|
|2|5|
|3|5|
|4|5|
|5|5|
|5|5|
|5|4|
|5|3|
|5|2|
|5|1|

Set all elements to 3 \(with *Y*&gt;*Z*\):

``` {#codeblock_yln_jny_gdc}
X = 1..10
Y = 6
Z = 3
clip(X,Y,Z) 
// output:[3,3,3,3,3,3,3,3,3,3]
```

Set a range \[3,5\]:

``` {#codeblock_lbf_kny_gdc}
X = dict(`a`b`c`d`e`f,[1,2,3,4,5,6])
Y = 3
Z = 5
clip(X,Y,Z)

/*
output:
a->3
b->3
c->3
d->4
e->5
f->5
*/
```

Example 2. When *Y* and *Z* are vectors

``` {#codeblock_plv_kny_gdc}
X = [1,2,3,4,5,6,7,8,9,10]
Y = [0,1,2,5,6,6,6,NULL,7,7]
Z = [3,4,5,6,7,8,NULL,5,5,9]
clip(X,Y,Z)
// output:[1,2,3,5,6,6,,,5,9]
```

Example 3. When *Y* or *Z* is a scalar, and the other is a vector, matrix, or table

Set a clipping range \[4,Z\[i,j\]\]:

``` {#codeblock_jbr_lny_gdc}
X = 1..8$2:4
Y = 4
Z = [5,6,5,6,NULL,3,5,6]$2:4
clip(X,Y,Z)
```

<table id="table_n52_mny_gdc"><tbody><tr><td align="left">

4

</td><td align="left">

4

</td><td align="left">

 

</td><td align="left">

5

</td></tr><tr><td align="left">

4

</td><td align="left">

4

</td><td align="left">

3

</td><td align="left">

6

</td></tr></tbody>
</table>