# clearTablePersistence {#cleartablepersistence}

## Syntax {#syntax}

`clearTablePersistence(table)`

## Arguments {#arguments}

**table** is a table object.

## Details {#details}

Disable a table's persistence to disk, then delete the content of the table on disk. The table schema remains.

## Examples {#examples}

```
colName=["time","x"]
colType=["timestamp","int"]
t = streamTable(100:0, colName, colType);
enableTableShareAndPersistence(table=t, tableName=`st, cacheSize=1200000)
go;
```

```
for(s in 0:200){
   n=10000
   time=2019.01.01T00:00:00.000+s*n+1..n
   x=rand(10.0, n)
   insert into st values(time, x)
}
clearTablePersistence(st);
```

Related commands: [enableTablePersistence](../e/enableTablePersistence.md), [disableTablePersistence](../d/disableTablePersistence.md)

