# clearDSCache! {#cleardscache}

## Syntax {#syntax}

`clearDSCache!(ds)`

## Arguments {#arguments}

**ds** is a data source or a list of data sources.

## Details {#details}

Instruct the system to clear the cache after the next time the data source is executed.

## Examples {#examples}

```
PTNDB_DIR = "/home/db_testing"
dbName = database(PTNDB_DIR + "/NYSETAQByName")
Trades = dbName.loadTable(`Trades)

ds=sqlDS(<select Time,Exchange,Symbol,Trade_Volume as Vol, Trade_Price as Price from Trades>)
ds.cacheDS!()        //cache the data
ds.clearDSCache!()   //clear the cache
```

