# clearComputeNodeCache {#clearComputeNodeCache}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`clearComputeNodeCache(database, [table], [partition])`

## Arguments {#arguments}

**database**is a string indicating the database name.

**table** \(optional\) is a string indicating the table name. It can contain the following wildcards:

-   "\*" \(default\): matches all;

-   "?": matches a single character;

-   "%": matches 0, 1 or more characters.


**partition** \(optional\) is a STRING scalar or vector indicating the DFS path of a partition. If *partition* is not specified, it indicates all partitions.

## Details {#details}

Call the function on a compute node within a compute group to clear the memory and disk cache.

Note: Executing this function does not guarantee that all cached data will be cleared.

## Examples {#topic_lfs_pz4_1fc}

Clear the memory cache and disk cache of the “database\_compute” database.

``` {#codeblock_pxh_rz4_1fc}
clearComputeNodeCache("dfs://database_compute")      
```

Clear the memory cache and disk cache of tables with the prefix of “pt” in the “database\_compute” database.

``` {#codeblock_ay2_sz4_1fc}
clearComputeNodeCache("dfs://database_compute","pt%")              
```

