# clearCachedModules {#clearcachedmodules}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`clearCachedModules()`

## Arguments {#arguments}

None

## Details {#details}

Clear all cached modules. After updating a module, execute this command to clear the cached module data. When you call the module via `use`, the system reloads it from the module file instead of using the cached data, and there is no need to restart the node.

Note: This function can only be executed by administrators.

## Examples {#examples}

Define a module.

```
module printLog
def printLog(){
print "hello"
}
```

Load the module.

```
use printLog
printLog()
// output: hello
```

Update the module.

```
module printLog
def printLog(){
print "hello new"
}
```

Before loading the updated module, call `clearCachedModules` to clear the cached module.

```
login("admin", "123456")

clearCachedModules();

use printLog
printLog()
// output: hello new
```

