# cholesky {#cholesky}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cholesky(obj, [lower=true])`

## Arguments {#arguments}

**obj** is a symmetric positive definite matrix.

**lower** \(optional\) is a Boolean value indicating whether the result is a lower triangular matrix \(true, default\) or an upper triangular matrix \(false\).

## Details {#details}

Conduct Cholesky decomposition of a symmetric positive-definite matrix.

## Examples {#examples}

```
m=[1, 0, 1, 0, 2, 0, 1, 0, 3]$3:3
L=cholesky(m);
L;
```

|\#0|\#1|\#2|
|---|---|---|
|1|0 96.56|0|
|0|1.414214|0|
|1|0|1.414214|

```
L**transpose(L);
```

|\#0|\#1|\#2|
|---|---|---|
|1|0|1|
|0|2|0|
|1|0|3|

```
cholesky(m, false);
```

|\#0|\#1|\#2|
|---|---|---|
|1|0|1|
|0|1.414214|0|
|0|0|1.414214|

