# checkBackup {#checkbackup}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`checkBackup(backupDir, dbPath, [tableName], [partition])`

## Arguments {#arguments}

**backupDir** is a string indicating the directory to save the backup.

**dbPath** is a string indicating the database path.

**tableName** \(optional\) is a string indicating the table name. If tableName is unspecified, all tables in the database are checked.

**partition** \(optional\) is a string indicating the relative path of the backup partitions. Use "?" as a single wildcard and "%" as a wildcard that can match zero or more characters.

-   For a certain partition, specify the relative path or "%/" + "partition name". For example, for the "20170810/50\_100" partition under "dfs://compoDB", specify "/compoDB/20170807/0\_50" or "%/20170807/0\_50" as partition path.

-   For all the partitions: specify "%".


## Details {#details}

Check the data integrity of the backup files. Return an empty table if all backup files are complete and accurate; Otherwise return the information of abnormal backup files. You can set *force*=true for function backup to enable force backup to restore the corrupt backup partitions.

## Examples {#examples}

```
dbName = "dfs://compoDB2"
n=1000
ID=rand("a"+string(1..10), n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10, n)
t=table(ID, date, x)
db1 = database(, VALUE, 2017.08.07..2017.08.11)
db2 = database(, HASH,[INT, 20])
if(existsDatabase(dbName)){
dropDatabase(dbName)
}
db = database(dbName, COMPO,[ db1,db2])

//create 2 tables
pt1 = db.createPartitionedTable(t, `pt1, `date`x).append!(t)
pt2 = db.createPartitionedTable(t, `pt2, `date`x).append!(t)

//back up pt1 with SQL statement
backup(backupDir=backupDir1, sqlObj=<select * from pt1>, parallel=true)
//back up pt2 by copying files
backup(backupDir=backupDir2, dbName, parallel=true, tableName=`pt2)

//check data integrity
checkBackup(backupDir=backupDir2, dbPath=dbName, tableName="pt2")  //return an empty table
checkBackup(backupDir=backupDir1, dbPath=dbName, tableName="pt1")  //return the corrupted chunk information
```

|dbName|tableName|chunkPath|chunkID|partitionPath|
|------|---------|---------|-------|-------------|
|dfs://compoDB2 pt1|/compoDB2/20170807/Key2/9|4ae71414-8bfe-4283-b04c-b2e48e90be08|/20170807/Key2||

In the above example, there is a corrupt chunk file of pt1. We can restore the file by setting *force*=true to back up the table again.

```
backup(backupDir1, <select * from pt1>,force=true, parallel=true)
checkBackup(backupDir=backupDir1, dbPath=dbName, tableName="pt1")  // return an empty table
```

