# changePwd {#changepwd}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`changePwd(oldPwd, newPwd)`

## Arguments {#arguments}

**oldPwd** is a string indicating the current password for the user.

**newPwd** is a string indicating the new password for the user. It cannot contain space or control characters.

Since DolphinDB 2.00.10.10, users can determine whether to verify the complexity of *newPwd* by setting the configuration *enhancedSecurityVerification*. If it is not specified, no verification will be applied; if it is set to true, the password must meet the following conditions:

-   8-20 characters

-   at least 1 capital letter

-   at least 1 special character, including !"\#$%&amp;'\(\)\*+,-./:;&lt;=&gt;?@\[\]^\_\`\{\|\}~


## Details {#details}

Change password.

## Examples {#examples}

```
changePwd(`LTmp4389, `T5139pm);
```

