# cds {#cds}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cds(settlement, maturity, evalDate, notional, spread, riskFree, recovery, isSeller, frequency, calendar, [convention='Following'], [termDateConvention='Following'], [rule='CDS'], [basis=1])`

## Details {#details}

Value a Credit Default Swap \(CDS\) contract.

**Return value**: A DOUBLE scalar or vector.

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**settlement** is a DATE scalar or vector indicating the settlement date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**evalDate** is a DATE scalar or vector indicating the evaluation date of the CDS contract. Note that *evalDate* should be no later than *settlement*.

**notional** is a non-negative numeric scalar or vector indicating the notional principal of the CDS contract.

**spread** is a numeric scalar or vector indicating the CDS spread. The CDS spread is the amount the buyer pays to the seller each period, which is quoted as a percentage of the contract’s notional principal in basis points \(bps\).

**riskFree** is a numeric scalar or vector indicating the risk-free interest rate.

**recovery** is a numeric scalar or vector in \[0,1\), indicating the recovery rate. It is the estimated percentage of par value that the bondholder will receive after a credit event \(e.g., default\).

**isSeller** is a BOOLEAN scalar or vector indicating whether the party is the buyer or the seller. true for the seller and false for the buyer.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**calendar** is a STRING scalar or vector indicating the trading calendar\(s\). See [Trading Calendar](../../Tutorials/trading_calendar.md) for more information.

**convention** \(optional\) is a STRING scalar or vector indicating how cash flows that fall on a non-trading day are treated. The following options are available. Defaults to 'Following'.

-   'Following': The following trading day.
-   'ModifiedFollowing': The following trading day. If that day is in a different month, the preceding trading day is adopted instead.
-   'Preceding': The preceding trading day.
-   'ModifiedPreceding': The preceding trading day. If that day is in a different month, the following trading day is adopted instead.
-   'Unadjusted': Unadjusted.
-   'HalfMonthModifiedFollowing': The following trading day. If that day crosses the mid-month \(15th\) or the end of month, the preceding trading day is adopted instead.
-   'Nearest': The nearest trading day. If both the preceding and following trading days are equally far away, default to following trading day.

**termDateConvention** \(optional\) is a STRING scalar or vector indicating how maturity date that falls on a non-trading day is treated. Parameter options and the default value are the same as *convention*.

**rule** \(optional\) is a STRING scalar or vector indicating how the list of dates is generated. It can be:

-   'Backward': Backward from maturity date to settlement date.
-   'Forward': Forward from settlement date to maturity date.
-   'Zero': No intermediate dates between settlement date and maturity date.
-   'ThirdWednesday': All dates but settlement date and maturity date are taken to be on the third Wednesday of their month \(with forward calculation\).
-   'ThirdWednesdayInclusive': All dates are taken to be on the third Wednesday of their month \(with forward calculation\).
-   'Twentieth': All dates but the settlement date are taken to be the twentieth of their month \(used for CDS schedules in emerging markets\). The maturity date is also modified.
-   'TwentiethIMM': All dates but the settlement date are taken to be the twentieth of an IMM \(International Money Market\) month\(used for CDS schedules\). The maturity date is also modified.
-   'OldCDS': Same as TwentiethIMM with unrestricted date ends and long/short stub coupon period \(old CDS convention\).
-   'CDS' \(default\): [Credit derivatives standard rule](https://www.isda.org/2009/03/12/big-bang-protocol/) defined in the "Big Bang" Protocol in 2009.

-   'CDS2015': [Ammended credit derivatives standard rule](https://www.isda.org/2015/07/07/amending-when-single-name-cds-roll-to-new-on-the-run-contracts/) that took effect on December 20, 2015.


## Examples {#examples}

The following example values the specified CDS contract based on the input.

``` {#codeblock_xsb_jb3_fdc}
valDate = 2007.05.15     
settlement = 2007.05.16
maturity = 2007.08.16
notional = 1000000.0
spread = 0.0150
riskFreeRate = 0.01
recoveryRate = 0.5
isSeller = true
frequency = 4
convention = 'Following'
termDateConvention = 'Unadjusted'
rule = 'TwentiethIMM'
basis = 3
cds(settlement, maturity, valDate, notional, spread, riskFreeRate, recoveryRate, isSeller, frequency, 'CCFX', convention, termDateConvention, rule, basis)
// Output: -5.448913728297157
```

