# cast {#cast}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cast(X, Y)`

or

`X $ Y`

## Arguments {#arguments}

**X** can be of any data form.

**Y** is a data type or a data pair.

## Details {#details}

-   convert a data type to another;

-   reshape a matrix, or convert between matrices and vectors.


## Examples {#examples}

```
x=8.9$INT;
x;
// output: 9

x=1..10;
x;
// output: [1,2,3,4,5,6,7,8,9,10]

typestr x;
// output: FAST INT VECTOR

x/2;
// output: [0,1,1,2,2,3,3,4,4,5]

x=x$DOUBLE;
typestr x;
// output: FAST DOUBLE VECTOR

x/2;
// output: [0.5,1,1.5,2,2.5,3,3.5,4,4.5,5]

x=`IBM`MS;
typestr x;
// output: STRING VECTOR

x=x$SYMBOL;
typestr x;
// output: FAST SYMBOL VECTOR

x=`128.9;
typestr x;
// output: STRING

x=x$INT;
x;
// output: 128
typestr x;
// output: INT

// convert a vector to a matrix
m=1..8$2:4;
m;
```

|0|1|2|3|
|:---|:---|:---|:---|
|1|3|5|7|
|2|4|6|8|

```
// reshape a matrix
m$4:2;
```

|0|1|
|---|---|
|1|5|
|2|6|
|3|7|
|4|8|

```
m$1:size(m);
```

|0|1|2|3|4|5|6|7|
|:---|:---|:---|:---|:---|:---|:---|:---|
|1|2|3|4|5|6|7|8|

