# cancelConsoleJob {#cancelconsolejob}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cancelConsoleJob(rootJobId)`

## Arguments {#arguments}

**rootJobId** is the job ID\(s\). It is a STRING scalar or vector. If it is a vector, multiple jobs are canceled at the same time.

## Details {#details}

Cancel submitted but unfinished interactive job\(s\). To cancel batch jobs, use [cancelJob](cancelJob.md).

**Note:** This command cancels a job only after the currently running sub tasks of the job are finished. Therefore the command may not immediately take effect. If a job has no sub task, this command will not take effect.

## Examples {#examples}

In a session of a data node, execute the following script:

```
pt = loadTable("dfs://TAQ", `quotes)
select count(*) from pt;
```

In another session of the same data node, call [getConsoleJobs](../g/getConsoleJobs.md) to get the *rootJobId* of the job to be canceled, then execute `cancelConsoleJob` with the rootJobId:

```
cancelConsoleJob("bf768327-776d-40a7-8a8d-00a6cfd054e3");
```

