# callMCPTool {#callMCPTool}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`callMCPTool(name, [args], [published])`

## Arguments {#arguments}

**name** is a STRING scalar indicating the tool name.

**args** \(optional\) is a dictionary where keys are strings and values are ANY or STRING, representing arguments to pass to the tool.

**published** \(optional\) is a Boolean value indicating whether to call the published version of the tool. Defaults to false, meaning to call the unpublished version.

## Details {#details}

Calls the specified MCP tool.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
// Define a tool and publish it
def myTool(x) {
   return x * 2 + 1
}

info = {
    "title": "DolphinDB Tool"
}

addMCPTool(name="myTool", func=myTool, argNames=["a"], argTypes=["number"], description="This is a tool", extraInfo=info)

publishMCPTools(names="myTool")

// Update the tool without publishing
def myNewTool(x) {
   return 100 * x
}

updateMCPTool(name="myTool", func=myNewTool)

// Call the published version
callMCPTool(name="myTool", args={"a":3}, published=true)
// output:'7'

// Call the updated but unpublished version
callMCPTool(name="myTool", args={"a":3}, published=false)
// output: '300'
```

