# cacheDSNow {#cachedsnow}

## Syntax {#syntax}

`cacheDSNow(ds)`

## Arguments {#arguments}

**ds** is a data source or a list of data sources.

## Details {#details}

Immediately execute and cache the data source. It returns the total number of cached rows.

## Examples {#examples}

```
PTNDB_DIR = "/home/db_testing"
dbName = database(PTNDB_DIR + "/NYSETAQByName")
Trades = dbName.loadTable(`Trades)

ds=sqlDS(<select Time,Exchange,Symbol,Trade_Volume as Vol, Trade_Price as Price from Trades>)
ds.cacheDSNow()        //cache the data immediately
ds.clearDSCacheNow()   //clear the cache immediately
```

