# bvls {#businessyearend}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bvls(Y, X, bounds, [maxIter], [tolerance=1e-10], [intercept=true], [mode=0])`

## Arguments {#arguments}

**Y** is a numeric vector indicating the dependent variable.

**X** is a numeric vector/matrix/table/tuple indicating the independent variable\(s\). When *X* is a matrix,

-   If the number of rows equals the length of *Y*, each column of *X* is a factor.
-   If the number of rows is not the same as the length of *Y*, and the number of columns equals the length of *Y*, each row of *X* is a factor.

Note: The values in *X* and *Y* will be converted to DOUBLE, and the null values after the conversion will be treated as 0.

**bounds** is a tuple of elements \(\[lb, ub\]\) specifying the lower and upper bounds. Each element of the tuple can be:

-   A scalar: specifies the same boundary for all factors.
-   A vector: specifies boundaries for each factor individually, with the vector length equal to the number of factors.

**maxIter** \(optional\) is a positive integer indicating the maximum number of iterations before termination, defaults to the number of variables.

**tolerance** \(optional\) is a DOUBLE value indicating the convergence threshold, defaults to 1e-10. Iteration stops when either:

-   The difference in loss function values between consecutive iterations &lt; *tolerance*;
-   The KKT \(Karush-Kuhn-Tucker\) conditions are satisfied within *tolerance*.

**intercept** \(optional\) is a Boolean variable indicating whether the regression includes the intercept. If it is true, the system automatically adds a column of 1 to *X* to generate the intercept. The default value is true.

**mode** \(optional\) is an integer indicating the contents in the output. Currently only 0 \(default\) is supported, returning a coefficient vector.

## Details {#details}

Perform Bounded-Variable Least Squares \(BVLS\) regression.

**Return value**: A DOUBLE vector indicating the estimated coefficients.

## Examples {#examples}

``` {#codeblock_cs2_ymd_gfc}
x1 = [1, 3, 5, 7, 11, 16, 23]
x2 = [2, 8, 11, 34, 56, 54, 100]
y = [0.1, 4.2, 5.6, 8.8, 22.1, 35.6, 77.2]
bounds = (0.0, 10.0)

bvls(y, x1, bounds)
// output: [0,2.717777777777778]

bvls(y, (x1, x2), bounds)
// output: [0,1.409643685501234,0.315943584131198]
```

Related functions: [ols](../o/ols.md)

