# businessDay {#businessday}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`businessDay(X, [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**offset** \(optional\) is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

If *X* is a business day \(Monday to Friday\), return date\(X\). Otherwise, return the most recent business day.

If parameter *offset* is specified, the result is updated every *n* business days. Parameter *offset* works only if parameter *n*&gt;1.

## Examples {#examples}

```
businessDay(2019.01.06);
// output: 2019.01.04

businessDay(2019.01.04);
// output: 2019.01.04

date=2019.01.06 + 1..10
businessDay = businessDay(date)
businessDay2 = businessDay(date,min(date),2)
table(date, businessDay, businessDay2);
```

|date|businessDay|businessDay2|
|----|-----------|------------|
|2019.01.07|2019.01.07|2019.01.07|
|2019.01.08|2019.01.08|2019.01.07|
|2019.01.09|2019.01.09|2019.01.09|
|2019.01.10|2019.01.10|2019.01.09|
|2019.01.11|2019.01.11|2019.01.11|
|2019.01.12|2019.01.11|2019.01.11|
|2019.01.13|2019.01.11|2019.01.11|
|2019.01.14|2019.01.14|2019.01.11|
|2019.01.15|2019.01.15|2019.01.15|
|2019.01.16|2019.01.16|2019.01.15|

