# bucket {#bucket}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bucket(vector, dataRange, bucketNum, [includeOutbound=false])`

## Arguments {#arguments}

**vector** is a numeric or temporal vector.

**dataRange** is a pair indicating the data range, which includes the lower bound and excludes the upper bound.

**bucketNum** is the number of buckets. When *dataRange* is specified as an INT PAIR, its range must be a multiple of *bucketNum*.

**includeOutbound** \(optional\) is a Boolean value indicating whether to include the bucket below the lower bound of the data range and the bucket beyond the upper bound of the data range. The default value is false.

## Details {#details}

Return a vector with the same length as the input *vector*. Each element of the result indicates which bucket each of the elements of the input vector belongs to, based on the bucket classification rules given by *dataRange* and *bucketNum*.

For example, if *dataRange* is 0:10, *bucketNum* is 2, and *includeOutbound* is unspecified, we have two buckets: \[0, 5\) and \[5,10\). Any value &lt;0 or &gt;=10 will be coded as a null integer. If *includeOutbound* is set to be true, the example above will generate 4 buckets: &lt;0, \[0, 5\), \[5,10\), &gt;=10.

## Examples {#examples}

```
bucket(9 23 54 36 46 12, 12:54, 2);
// output: [,0,,1,1,0]

bucket(9 23 54 36 46 12, 12:54, 2, 1);
// output: [0,1,3,2,2,1]
```

