# bondPricer {#bondPricer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bondPricer(instrument, pricingDate, discountCurve, [spreadCurve], [setting])`

## Details {#topic_xxb_mwq_ngc}

Prices a bond instrument, supporting output of multiple risk measures, including \(NPV \(Net Present Value\), Delta \(first-order sensitivity\), Gamma \(second-order sensitivity\), and Key Rate Duration \(sensitivity to interest rate shifts at specified key maturities\).

**Return value**:

-   If *setting*is not specified, returns the NPV \(a DOUBLE scalar\).

-   If *setting*is specified, returns a Dictionary&lt;STRING, ANY&gt; with the following key-value pairs:

    -   "npv": A DOUBLE scalar

    -   "discountCurveDelta": A DOUBLE scalar

    -   "discountCurveGamma": A DOUBLE scalar

    -   "discountCurveKeyRateDuration": A DOUBLE vector


## Arguments {#arguments}

**instrument** is an INSTRCMENT object representing the bond to be priced. The required key fields vary depending on the type of bond product; see [Bond Product Field Specifications](#topic_n1c_qwq_ngc) for details.

**pricingDate** is a DATE scalar specifying the pricing date.

**discountCurve** is a MKTDATA object of type IrYieldCurve representing the discount curve. See [Curve Field Specifications](#topic_ozj_qwq_ngc) for details.

**spreadCurve** \(optional\) is a MKTDATA object of type IrYieldCurve representing the credit spread curve. If not specified, defaults to a flat curve with 0% spread. See [Curve Field Specifications](#topic_ozj_qwq_ngc) for details.

**setting** \(optional\)is a Dictionary&lt;STRING, ANY&gt; with the following key-value pairs：

|Key|Value Type|Description|
|---|----------|-----------|
|"calcDiscountCurveDelta"|BOOL|Whether to compute the bond’s first-order sensitivity \(delta\) to the discount curve.|
|"calcDiscountCurveGamma"|BOOL|Whether to compute the bond’s second-order sensitivity \(gamma\) to the discount curve.|
|"calcDiscountCurveKeyRateDuration"|BOOL|Whether to compute the bond’s key rate durations.|
|"discountCurveShift"|DOUBLE scalar|The parallel shift applied to the discount curve. For example, a bp\(0.0001\).|
|"discountCurveKeyTerms"|DOUBLE scalar/vector|The specific maturity point\(s\) to calculate the key rate duration. For example, \[1.0, 3.0, 5.0\].|
|"discountCurveKeyShifts"|DOUBLE scalar/vector|The shift amounts corresponding to each maturity point. It has the same length with discountCurveKeyTerms. For example, \[0.0001, 0.0002, 0.0015\].|

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
bond  = {
    "productType": "Cash",
    "assetType": "Bond",
    "bondType": "FixedRateBond",
    "version": 0, 
    "instrumentId": "240025.IB",
    "start": 2024.12.25,
    "maturity": 2031.12.25,
    "issuePrice": 100.0,
    "coupon": 0.0149,
    "frequency": "Annual",
    "dayCountConvention": "ActualActualISDA"
}

pricingDate = 2025.08.18

curve = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": pricingDate,
    "currency": "CNY",
    "curveName": "CNY_TREASURY_BOND",
    "dayCountConvention": "ActualActualISDA",
    "compounding": "Compounded",
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates":[2025.09.18, 2025.11.18, 2026.02.18, 2026.08.18, 2027.08.18, 2028.08.18, 2030.08.18,
             2032.08.18, 2035.08.18, 2040.08.18, 2045.08.18, 2055.08.18,2065.08.18, 2075.08.18],
    "values":[1.3000, 1.3700, 1.3898, 1.3865, 1.4299, 1.4471, 1.6401,
              1.7654, 1.7966, 1.9930, 2.1834, 2.1397, 2.1987, 2.2225] / 100.0
}

instrument = parseInstrument(bond)
discountCurve = parseMktData(curve)

setting = dict(STRING, ANY)
setting["calcDiscountCurveDelta"] = true
setting["calcDiscountCurveGamma"] = true
setting["calcDiscountCurveKeyRateDuration"] = true
setting["discountCurveShift"] = 0.0001
setting["discountCurveKeyTerms"] = [1.0, 3.0, 5.0]
setting["discountCurveKeyShifts"] = [0.0002, 0.0003, 0.0001]

results = bondPricer(instrument, pricingDate, discountCurve, setting=setting)
print(results)

/* output:
npv->99.600846811350891
discountCurveDelta->-592.25994127828585
discountCurveGamma->4223.064257757869199
discountCurvekeyRateDuration->[0.012669167121743,0.069982332985636,1.955786205709234]
*/
```

**Related functions:** [parseInstrument](../p/parseInstrument.md), [parseMktData](../p/parseMktData.md)

## Bond Product Field Specifications {#topic_n1c_qwq_ngc}

**Discount Bond**

<table id="table_uzj_zwq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Cash"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "Bond"

</td><td>

√

</td></tr><tr><td>

bondType

</td><td>

STRING

</td><td>

Must be "DiscountBond"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

nominal

</td><td>

DOUBLE

</td><td>

Nominal amount, defalut 100

</td><td>

×

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

Bond code, e.g., "259926.IB"

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

issuePrice

</td><td>

DOUBLE

</td><td>

Issue price

</td><td>

√

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency, defaults to "CNY"

</td><td>

×

</td></tr><tr><td>

cashFlow

</td><td>

TABLE

</td><td>

Cash flow table

</td><td>

×

</td></tr><tr><td>

discountCurve

</td><td>

STRING

</td><td>

The discount curve, e.g., "CNY\_TRASURY\_BOND"

</td><td>

×

</td></tr><tr><td>

spreadCurve

</td><td>

STRING

</td><td>

The credit spread curve

</td><td>

×

</td></tr><tr><td>

subType

</td><td>

STRING

</td><td>

Subtypes. China's bonds include:

 -   "TREASURY\_BOND": Treasury Bonds

-   "CENTRAL\_BANK\_BILL": Central Bank Bills

-   "CDB\_BOND": Policy Bank Financial Bonds \(China Development Bank\)

-   "EIBC\_BOND": Policy Bank Financial Bonds \(Export-Import Bank of China\)

-   "ADBC\_BOND": Policy Bank Financial Bonds \(Agricultural Development Bank of China\)

-   "MTN": Medium-term Notes

-   "CORP\_BOND": Corporate Bonds

-   "UNSECURED\_CORP\_BOND": Unsecured Corporate Bonds

-   "SHORT\_FIN\_BOND": Short-term Financing Bills

-   "NCD": Negotiable Certificates of Deposit

-   "LOC\_GOV\_BOND": Local Government Bonds

-   "COMM\_BANK\_FIN\_BOND": Commercial Bank Financial Bonds

-   "BANK\_SUB\_CAP\_BOND": Bank Subordinated Capital Bonds

-   "ABS": Asset-backed Securities

-   "PPN": Privately Offered Bonds


</td><td>

×

</td></tr><tr><td>

creditRating

</td><td>

STRING

</td><td>

Credit rating. It can be: "B", "BB", "BBB", "BBB+", "A-", "A", "A+", "AA-", "AA", "AA+", "AAA-", "AAA", "AAA+"

</td><td>

×

</td></tr></tbody>
</table>**Zero Coupon Bond**

<table id="table_ixb_bxq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Cash"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "Bond"

</td><td>

√

</td></tr><tr><td>

bondType

</td><td>

STRING

</td><td>

Must be "ZeroCouponBond"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

nominal

</td><td>

DOUBLE

</td><td>

Nominal amount, defalut 100

</td><td>

×

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

Bond code, e.g., "259926.IB"

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

coupon

</td><td>

DOUBLE

</td><td>

Coupon rate, e.g., 0.03 means 3%

</td><td>

√

</td></tr><tr><td>

frequency

</td><td>

STRING

</td><td>

Frequency of interest payment

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency, defaults to "CNY"

</td><td>

×

</td></tr><tr><td>

cashFlow

</td><td>

TABLE

</td><td>

Cash flow table

</td><td>

×

</td></tr><tr><td>

discountCurve

</td><td>

STRING

</td><td>

The discount curve, e.g., "CNY\_TRASURY\_BOND"

</td><td>

×

</td></tr><tr><td>

spreadCurve

</td><td>

STRING

</td><td>

The credit spread curve

</td><td>

×

</td></tr><tr><td>

subType

</td><td>

STRING

</td><td>

Subtypes. China's bonds include:

 -   "TREASURY\_BOND": Treasury Bonds

-   "CENTRAL\_BANK\_BILL": Central Bank Bills

-   "CDB\_BOND": Policy Bank Financial Bonds \(China Development Bank\)

-   "EIBC\_BOND": Policy Bank Financial Bonds \(Export-Import Bank of China\)

-   "ADBC\_BOND": Policy Bank Financial Bonds \(Agricultural Development Bank of China\)

-   "MTN": Medium-term Notes

-   "CORP\_BOND": Corporate Bonds

-   "UNSECURED\_CORP\_BOND": Unsecured Corporate Bonds

-   "SHORT\_FIN\_BOND": Short-term Financing Bills

-   "NCD": Negotiable Certificates of Deposit

-   "LOC\_GOV\_BOND": Local Government Bonds

-   "COMM\_BANK\_FIN\_BOND": Commercial Bank Financial Bonds

-   "BANK\_SUB\_CAP\_BOND": Bank Subordinated Capital Bonds

-   "ABS": Asset-backed Securities

-   "PPN": Privately Offered Bonds


</td><td>

×

</td></tr><tr><td>

creditRating

</td><td>

STRING

</td><td>

Credit rating. It can be: "B", "BB", "BBB", "BBB+", "A-", "A", "A+", "AA-", "AA", "AA+", "AAA-", "AAA", "AAA+"

</td><td>

×

</td></tr></tbody>
</table>**Fixed Rate Bond**

<table id="table_b5p_cxq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Must be "Cash"

</td><td>

√

</td></tr><tr><td>

assetType

</td><td>

STRING

</td><td>

Must be "Bond"

</td><td>

√

</td></tr><tr><td>

bondType

</td><td>

STRING

</td><td>

Must be "FixedRateBond"

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

nominal

</td><td>

DOUBLE

</td><td>

Nominal amount, defalut 100

</td><td>

×

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

Bond code, e.g., "259926.IB"

</td><td>

×

</td></tr><tr><td>

start

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

maturity

</td><td>

DATE

</td><td>

Maturity date

</td><td>

√

</td></tr><tr><td>

coupon

</td><td>

DOUBLE

</td><td>

Coupon rate, e.g., 0.03 means 3%

</td><td>

√

</td></tr><tr><td>

frequency

</td><td>

STRING

</td><td>

Frequency of interest payment

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention. It can be: "ActualActualISDA", "ActualActualISMA"," Actual365", "Actual360"

</td><td>

√

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency, defaults to "CNY"

</td><td>

×

</td></tr><tr><td>

cashFlow

</td><td>

TABLE

</td><td>

Cash flow table

</td><td>

×

</td></tr><tr><td>

discountCurve

</td><td>

STRING

</td><td>

The discount curve, e.g., "CNY\_TRASURY\_BOND"

</td><td>

×

</td></tr><tr><td>

spreadCurve

</td><td>

STRING

</td><td>

The credit spread curve

</td><td>

×

</td></tr><tr><td>

subType

</td><td>

STRING

</td><td>

Subtypes. China's bonds include:

 -   "TREASURY\_BOND": Treasury Bonds

-   "CENTRAL\_BANK\_BILL": Central Bank Bills

-   "CDB\_BOND": Policy Bank Financial Bonds \(China Development Bank\)

-   "EIBC\_BOND": Policy Bank Financial Bonds \(Export-Import Bank of China\)

-   "ADBC\_BOND": Policy Bank Financial Bonds \(Agricultural Development Bank of China\)

-   "MTN": Medium-term Notes

-   "CORP\_BOND": Corporate Bonds

-   "UNSECURED\_CORP\_BOND": Unsecured Corporate Bonds

-   "SHORT\_FIN\_BOND": Short-term Financing Bills

-   "NCD": Negotiable Certificates of Deposit

-   "LOC\_GOV\_BOND": Local Government Bonds

-   "COMM\_BANK\_FIN\_BOND": Commercial Bank Financial Bonds

-   "BANK\_SUB\_CAP\_BOND": Bank Subordinated Capital Bonds

-   "ABS": Asset-backed Securities

-   "PPN": Privately Offered Bonds


</td><td>

×

</td></tr><tr><td>

creditRating

</td><td>

STRING

</td><td>

Credit rating. It can be: "B", "BB", "BBB", "BBB+", "A-", "A", "A+", "AA-", "AA", "AA+", "AAA-", "AAA", "AAA+"

</td><td>

×

</td></tr></tbody>
</table>## Curve Field Specifications {#topic_ozj_qwq_ngc}

<table id="table_zcd_2xq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Curve"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

curveType

</td><td>

STRING

</td><td>

Must be "IrYieldCurve"

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention to use. It can be:

 -   "Actual360": actual/360

-   "Actual365": actual/365

-   "ActualActualISMA": actual/actual according to ISMA \(International Securities Market Association\) convention

-   "ActualActualISDA": actual/actual according to ISDA \(International Swaps and Derivatives Association\) convention.


</td><td>

√

</td></tr><tr><td>

interpMethod

</td><td>

STRING

</td><td>

Interpolation method. It can be:

 -   "Linear": linear interpolation

-   "CubicSpline": cubic spline interpolation

-   "CubicHermiteSpline": cubic Hermite interpolation


</td><td>

√

</td></tr><tr><td>

extrapMethod

</td><td>

STRING

</td><td>

Extrapolation method. It can be

 -   Flat: flat extrapolation

-   Linear: linear extrapolation


</td><td>

√

</td></tr><tr><td>

dates

</td><td>

DATE vector

</td><td>

Date of each data point

</td><td>

√

</td></tr><tr><td>

values

</td><td>

DOUBLE vector

</td><td>

Value of each data point, corresponding to the elements in dates.

</td><td>

√

</td></tr><tr><td>

curveName

</td><td>

STRING

</td><td>

Curve name

</td><td>

×

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency. It can be CNY", "USD", "EUR", "GBP", "JPY", "HKD"

</td><td>

√

</td></tr><tr><td>

compounding

</td><td>

STRING

</td><td>

The compounding interest. It can be:

 -   "Compounded": discrete compounding

-   "Simple": simple interest \(no compounding\).

-   "Continuous": continuous compounding.


</td><td>

√

</td></tr><tr><td>

settlement

</td><td>

DATE

</td><td>

Settlement date. If specified, all subsequent tenor intervals are computed starting from "settlement" rather than from "referenceDate".

</td><td>

×

</td></tr><tr><td>

frequency

</td><td>

INTEGRAL/STRING

</td><td>

The interest payment frequency. Supported values:

 -   -1 or "NoFrequency": No payment frequency

-   0 or "Once": Single lump-sum payment of principal and interest at maturity.

-   1 or "Annual": Annually

-   2 or "Semiannual": Semiannually

-   3 or "EveryFourthMonth": Every four months

-   4 or "Quarterly": Quarterly

-   6 or "BiMonthly": Every two months

-   12 or "Monthly": Monthly

-   13 or "EveryFourthWeek": Every four weeks

-   26 or "BiWeekly": Every two weeks

-   52 or "Weekly": Weekly

-   365 or "Daily": Daily

-   999 or "Other": Other frequencies


</td><td>

×

</td></tr><tr><td>

curveModel

</td><td>

STRING

</td><td>

Curve construction model; It can be "Bootstrap" \(default\), "NS", "NSS".

 When the value is "NSS" or "NS", the fields interpMethod, extrapMethod, dates, and values are not required.

</td><td>

×

</td></tr><tr><td>

curveParams

</td><td>

DICT

</td><td>

Model parameters. It is required when *curveModel*is "NSS" or "NS":

 -   If curveModel = "NS": must include keys 'beta0', 'beta1', 'beta2', 'lambda'.


 -   If curveModel = "NSS": must include keys 'beta0', ‘beta1', 'beta2', 'beta3', 'lambda0', 'lambda1'.


</td><td>

×

</td></tr></tbody>
</table>