# bondDirtyPrice {#bonddirtyprice}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bondDirtyPrice(start, maturity, issuePrice, coupon, frequency, dayCountConvention, bondType, settlement, price, priceType, [benchmark='Excel'])`

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**start**is a scalar or vector of DATE type, indicating the bond’s value date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**issuePrice**is a numeric scalar or vector of the same length as *start* indicating the bond’s issue price. For discount bonds, the actual issue price must be specified \(typically less than 100\); for other bonds, it is usually 100.

**coupon** is a numeric scalar or vector indicating the annual coupon rate. For example, 0.03 indicates a 3% annual coupon.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**dayCountConvention** is a STRING scalar or vector indicating the day count convention to use. It can be:

-   "Thirty360US": US \(NASD\) 30/360
-   "ActualActualISMA" \(default\): actual/actual \(ISMA rule\)
-   "Actual360": actual/360
-   "Actual365": actual/365
-   "Thirty360EU": European 30/360
-   "ActualActualISDA" \(default\): actual/actual \(ISDA rule\)

**bondType** is a STRING scalar or vector indicating the bond type. It can be:

-   "FixedRate": Fixed-rate bond, where interest is paid periodically based on the coupon rate.
-   "Discount": Discount bond, where no interest is paid, and the bond is issued at a discount. FV at maturity = face value.
-   "ZeroCoupon": Zero-coupon bond, where interest and face value are paid at maturity. FV at maturity = face value + interest.

**settlement** is a DATE scalar or vector indicating the settlement date.

**price**is a numeric scalar or vector whose meaning depends on the value of *priceType*:

-   When *priceType* is "YTM", *price* indicates the bond's yield to maturity.
-   When *priceType* is "CleanPrice", *price* indicates the bond's clean price.

**priceType** is a STRING scalar or vector used to specify the type of the bond price \(*price*\). It can be:

-   "YTM": Yield to Maturity.
-   "CleanPrice": Clean price.

**benchmark**\(optional\) is a STRING scalar indicating the reference algorithm. Currently, only "Excel" \(the algorithm used in Excel\) is supported.

## Details {#details}

`bondDirtyPrice` returns the dirty price of a bond with a face value of 100.

## Examples {#examples}

``` {#codeblock_yxr_k2c_zzb}
bondDirtyPrice(start=2023.01.01, maturity=2030.12.31, issuePrice=100, coupon=0.05, frequency=1, dayCountConvention="ActualActualISMA", bondType="FixedRate", settlement=2023.04.01, price=100.2143, priceType="CleanPrice")
// output: 101.447176
```

