# bondCashflow {#fiCashflow}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bondCashflow(start, maturity, coupon, frequency, dayCountConvention, bondType, [mode='Vector'])`

## Details {#details}

`bondCashflow` calculates the cash flow for a bond with a face value of 100. Supports fixed-rate bonds, zero-coupon bonds, and discount bonds.

**Return value**

-   If mode = "Vector", it returns a DOUBLE vector or an array vector that lists the cash flow amounts for a single bond or multiple bonds.

-   If mode = "Table", it returns a table or a tuple of tables, each representing the detailed cash flows of a single bond or multiple bonds. Each table contains the following fields:

    -   paymentDate: DATE, payment date.

    -   coupon: DOUBLE, interest amount.

    -   notional: DOUBLE, principal.

    -   total: DOUBLE, total amount.


## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**start**is a scalar or vector of DATE type, indicating the bond’s value date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**coupon** is a numeric scalar or vector indicating the annual coupon rate. For example, 0.03 indicates a 3% annual coupon.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**dayCountConvention** is a STRING scalar or vector indicating the day count convention to use. It can be:

-   "Thirty360US": US \(NASD\) 30/360
-   "ActualActualISMA" \(default\): actual/actual \(ISMA rule\)
-   "Actual360": actual/360
-   "Actual365": actual/365
-   "Thirty360EU": European 30/360
-   "ActualActualISDA" \(default\): actual/actual \(ISDA rule\)

**bondType** is a STRING scalar or vector indicating the bond type. It can be:

-   "FixedRate": Fixed-rate bond, where interest is paid periodically based on the coupon rate.
-   "Discount": Discount bond, where no interest is paid, and the bond is issued at a discount. FV at maturity = face value.
-   "ZeroCoupon": Zero-coupon bond, where interest and face value are paid at maturity. FV at maturity = face value + interest.

**mode** is a STRING scalar or vector specifying the output format. The values are:

-   "Vector" \(default\): returns only the cash flow amounts.
-   "Table": returns a detailed cash flow table.

## Examples {#examples}

``` {#codeblock_w33_rxb_bdc}
frequency="Annual"
start=2022.09.28
maturity=2025.09.28
coupon=0.078
bondCashflow(start=start, maturity=maturity, coupon=coupon, frequency=frequency, dayCountConvention="Thirty360US", bondType="FixedRate")

// output: [7.8,7.8,107.799999]

bondCashflow(start=start, maturity=maturity, coupon=coupon, frequency=frequency, dayCountConvention="Thirty360US", bondType="FixedRate", mode="Table")

/* output:
paymentDate coupon notional total              
----------- ------ -------- ----------
2023.09.28  7.8    0        7.8                
2024.09.28  7.8    0        7.8                
2025.09.28  7.8    100      107.799999
*/
```

