# bondAccrInt {#bondAccrInt}

## Syntax {#Syntax .section}

`bondAccrInt(start, maturity, issuePrice, coupon, frequency, dayCountConvention, bondType, settlement, [benchmark='Excel'])`

## Arguments {#Arguments .section}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**start**is a scalar or vector of DATE type, indicating the bond’s value date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**issuePrice**is a numeric scalar or vector of the same length as *start* indicating the bond’s issue price. For discount bonds, the actual issue price must be specified \(typically less than 100\); for other bonds, it is usually 100.

**coupon** is a numeric scalar or vector indicating the annual coupon rate. For example, 0.03 indicates a 3% annual coupon.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**dayCountConvention** is a STRING scalar or vector indicating the day count convention to use. It can be:

-   "Thirty360US": US \(NASD\) 30/360
-   "ActualActualISMA" \(default\): actual/actual \(ISMA rule\)
-   "Actual360": actual/360
-   "Actual365": actual/365
-   "Thirty360EU": European 30/360
-   "ActualActualISDA" \(default\): actual/actual \(ISDA rule\)

**bondType** is a STRING scalar or vector indicating the bond type. It can be:

-   "FixedRate": Fixed-rate bond, where interest is paid periodically based on the coupon rate.
-   "Discount": Discount bond, where no interest is paid, and the bond is issued at a discount. FV at maturity = face value.
-   "ZeroCoupon": Zero-coupon bond, where interest and face value are paid at maturity. FV at maturity = face value + interest.

**settlement** is a DATE scalar or vector indicating the settlement date.

**benchmark**\(optional\) is a STRING scalar indicating the reference algorithm. Currently, only "Excel" \(the algorithm used in Excel\) is supported.

## Details {#Details .section}

`bondAccrInt` returns the accrued interest of a security. Accrued interest is the interest on a bond or loan that has accumulated since the principal investment, or since the previous coupon payment if there has been one already.

The clean price is the price of a bond excluding any interest accrued since bond's issuance and the most recent coupon payment. Comparatively, the dirty price is the price of a bond including the accrued interest. Therefore,

Clean Price = Dirty Price − Accrued Interest

**Return value**: Scalar or vector of DOUBLE type.

## Examples {#Examples .section}

``` {#codeblock_p3y_xmr_z1c}
bondAccrInt(start=2024.01.01, maturity=2030.12.31, issuePrice=100, coupon=0.1, frequency=2, dayCountConvention="Thirty360US", bondType="FixedRate", settlement=2024.05.15)

// output: 3.75
```

Related function: [bondDirtyPrice](bondDirtyPrice.md)

**Parent topic:**[Functions](../../Functions/category.md)

