# binsrch {#binsrch}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`binsrch(X, Y)`

## Arguments {#arguments}

**X** must be a vector sorted in ascending order.

**Y** is a scalar/vector/tuple/matrix/array vector/dictionary/table.

## Details {#details}

`binsrch` means binary search. For each element in *Y*, `binsrch` locates its position in *X*. If nothing is found, it returns -1\(s\).

For optimal performance, we should use `binsrch` to search a short *Y* within a long sorted vector *X*. To search a large vector against another large unsorted vector, we should use function [find](../f/find.md), which is implemented using a hash table. However, building a hash table takes time and memory. Please also check the related function [in](../i/in.md).

## Examples {#examples}

```
1..100 binsrch 12 6 88 102;
// output: [11,5,87,-1]
```

