# bar {#bar}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`bar(X, interval, [closed='left'])`

## Arguments {#arguments}

**X** is an integral/temporal scalar or vector.

**interval** is an integral/DURATION type scalar greater than 0 or a vector of the same length as *X*.

When *interval* is of type DURATION, the following time units are supported \(case-sensitive\): w, d, H, m, s, ms, us, ns.

Note: As time units *y* and *M* are not supported in interval, to group *X* by year or month, convert the data format of *X* with function [month](../m/month.md) or [year](../y/year.md). Specify the interval as an integer for calculation. You can refer to Example 2.

**closed** \(optional\) is a string which can take 'left' \(default\) or 'right', indicating whether an element of *X* that is divisible by interval is the left boundary \(the first element of the group\) or the right boundary \(the last element of the group\) of a group.

-   *closed* = 'left': X-\(X % interval\), indicating that the value with a remainder of 0 is specified as the left boundary of a group.

-   *closed* = 'right': iif\(\(X % interval\) == 0, X, X + \(interval-\(X % interval\)\)\), indicating that the value with a remainder of 0 is specified as the right boundary of a group.


## Details {#details}

`bar` can group *X* based on the length specified by *interval*. Return a vector with the same length as *X*.

## Examples {#examples}

```
bar(100,3);               // 100-(100%3)=100-1=99
// output: 99

bar(0..15, 3)
// output: [0,0,0,3,3,3,6,6,6,9,9,9,12,12,12,15]

x=[7,4,5,8,9,3,3,5,2,6,12,1,0,-5,32]
bar(x, 5)
// output: [5,0,5,5,5,0,0,5,0,5,10,0,0,-5,30]

t=table(2021.01.01T01:00:00..2021.01.01T01:00:29 as time, rand(1.0, 30) as x)
select max(x) from t group by bar(time,5s)
```

|bar\_time|max\_x|
|---------|------|
|2021.01.01T01:00:00|0.539024|
|2021.01.01T01:00:05|0.793327|
|2021.01.01T01:00:10|0.958522|
|2021.01.01T01:00:15|0.96987|
|2021.01.01T01:00:20|0.827086|
|2021.01.01T01:00:25|0.617353|

In the following example, to group data by every 3 months, convert *X* with the `month` function, and specify *duration* as an integer in `bar`.

```
t=table(take(2018.01.01T01:00:00+1..10,10) join take(2018.02.01T02:00:00+1..10,10) join take(2018.03.01T08:00:00+1..10,10) join take(2018.04.01T08:00:00+1..10,10) join take(2018.05.01T08:00:00+1..10, 10) as time, rand(1.0, 50) as x)
select max(x) from t group by bar(month(time), 3);
```

|bar|max\_x|
|---|------|
|2018.01M|0.9868|
|2018.04M|0.9243|

The following example groups data by week and calculates the maximum values for each week. Depending on parameter *closed*, the results are different.

```
t=table(2022.01.01 + 1..20  as time, rand(100, 20) as x)
```

|time|x|
|----|---|
|2022.01.02|6|
|2022.01.03|29|
|2022.01.04|71|
|2022.01.05|56|
|2022.01.06|93|
|2022.01.07|34|
|2022.01.08|77|
|2022.01.09|18|
|2022.01.10|62|
|2022.01.11|33|
|2022.01.12|34|
|2022.01.13|64|
|2022.01.14|80|
|2022.01.15|63|
|2022.01.16|17|
|2022.01.17|66|
|2022.01.18|85|
|2022.01.19|27|
|2022.01.20|77|
|2022.01.21|27|

```
select max(x) from t group by bar(time, 7d);
```

|bar\_time|max\_x|
|---------|------|
|2021.12.30|71|
|2022.01.06|93|
|2022.01.13|85|
|2022.01.20|77|

```
print  select max(x) from t group by bar(time, 7d, closed='right');
```

|bar\_time|max\_x|
|---------|------|
|2021.01.06|93|
|2022.01.13|77|
|2022.01.20|85|
|2022.01.27|27|

When calculating 1-minute OHLC bars, the data type needs to be converted to LONG if n needs to be converted to NANOTIMESTAMP, otherwise an integer overflow will occur.

```
n = 1000000
nano = (09:30:00.000000000 + rand(long(6.5*60*60*1000000000), n)).sort!()
price = 100+cumsum(rand(0.02, n)-0.01)
volume = rand(1000, n)
symbol = rand(`600519`000001`600000`601766, n)
tradeNano = table(symbol, nano, price, volume).sortBy!(`symbol`nano)
undef(`nano`price`volume`symbol)
barMinutes = 7
itv = barMinutes*60*long(1000000000)

OHLC_nano=select first(price) as open, max(price) as high, min(price) as low, last(price) as close, sum(volume) as volume from tradeNano group by symbol, bar(nano, itv) as barStart
```

Related function: [dailyAlignedBar](../d/dailyAlignedBar.md)

