# backupDB {#backupdb}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`backupDB(backupDir, dbPath, [keyPath])`

## Arguments {#arguments}

**backupDir** is a string indicating the directory to save the backup.

**dbPath** is a string indicating the database path.

**keyPath** \(optional, Linux only\) is a STRING scalar that specifies the path to the TDE key file used for backup encryption. If left empty, no encryption will be applied.

## Details {#details}

Back up the specific database to the specified directory.

The function is equivalent to `backup(backupDir, dbPath, force=false, sparallel=true, snapshot=true)`.

## Examples {#examples}

```
dbName = "dfs://compoDB2"
n=1000
ID=rand("a"+string(1..10), n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10, n)
t=table(ID, date, x)
db1 = database(, VALUE, 2017.08.07..2017.08.11)
db2 = database(, HASH,[INT, 20])
if(existsDatabase(dbName)){
  dropDatabase(dbName)
}
db = database(dbName, COMPO,[ db1,db2])

//create 2 tables
pt1 = db.createPartitionedTable(t, `pt1, `date`x).append!(t)
pt2 = db.createPartitionedTable(t, `pt2, `date`x).append!(t)

backupDB(backupDir, dbName)
```

Related functions: [backup](backup.md), [backupTable](backupTable.md), [restore](../r/restore.md), [restoreDB](../r/restoreDB.md), [restoreTable](../r/restoreTable.md), [migrate](../m/migrate.md)

