# atImin {#atimin}

## Syntax {#syntax}

`atImin(location, value)`

## Arguments {#arguments}

**location** and **value** are vectors/matrices/tables of the same dimensions.

## Details {#details}

Find the position of the element with the smallest value in *location*, and return the value of the element in the same position in *value*. If there are multiple identical minimums in *location*, return the position of the first minimum.

If *location* and *value* are matrices, conduct the aforementioned calculation with each column of *location* and the corresponding column of *value*.

`atImin(location, value)` is equivalent to `value[imin(location)]`.

## Examples {#examples}

```
atImin(3 5 1 2, 9 7 5 3)
// output: 5

m1=matrix(9 2 1 5 6 9, 3 1 3 NULL 5 2, 2 8 1 2 3 4)
m2=matrix(1..6, 1..6, 1..6)
atImin(m1,m2)
// output: [3,2,3]
```

Related functions: [imin](../i/imin.md), [atImax](atImax.md)

