# atImax {#atimax}

## Syntax {#syntax}

`atImax(location, value)`

## Arguments {#arguments}

**location** and **value** are vectors/matrices/tables of the same dimensions.

## Details {#details}

Find the position of the element with the largest value in *location*, and return the value of the element in the same position in *value*. If there are multiple identical maximums in *location*, return the position of the first maximum.

If *location* and *value* are matrices, conduct the aforementioned calculation with each column of *location* and the corresponding column of *value*.

`atImax(location, value)` is equivalent to `value[imax(location)]`.

## Examples {#examples}

```
atImax(3 5 1 2, 9 7 5 3)
// output: 7

m1=matrix(9 2 1 5 6 9, 3 1 3 NULL 5 2, 2 8 1 2 3 4)
m2=matrix(1..6, 1..6, 1..6)
atImax(m1,m2)
// output: [1,5,2]
```

Related functions: [imax](../i/imax.md), [atImin](atImin.md)

