# asFreq {#asfreq}

## Syntax {#syntax}

`asFreq(X, rule, [closed], [label], [origin='start_day'])`

Alias: asfreq

## Arguments {#arguments}

**X** is an indexed matrix or indexed series. The index must be of temporal type.

**rule** is a string that can take the following values:

|Value of *rule*|Corresponding DolphinDB function|
|---------------|--------------------------------|
|"B"|businessDay|
|"W"|weekEnd|
|"WOM"|weekOfMonth|
|"LWOM"|lastWeekOfMonth|
|"M"|monthEnd|
|"MS"|monthBegin|
|"BM"|businessMonthEnd|
|"BMS"|businessMonthBegin|
|"SM"|semiMonthEnd|
|"SMS"|semiMonthBegin|
|"Q"|quarterEnd|
|"QS"|quarterBegin|
|"BQ"|businessQuarterEnd|
|"BQS"|businessQuarterBegin|
|"REQ"|FY5253Quarter|
|"A"|yearEnd|
|"AS"|yearBegin|
|"BA"|businessYearEnd|
|"BAS"|businessYearBegin|
|"RE"|FY5253|
|"D"|date|
|"H"|hourOfDay|
|"min"|minuteOfHour|
|"S"|secondOfMinute|
|"L"|millisecond|
|"U"|microsecond|
|"N"|nanosecond|
|"SA"|semiannualEnd|
|"SAS"|semiannualBegin|

The strings above can also be used with positive integers for parameter *rule*. For example, "2M" means the end of every two months. In addition, *rule* can also be set as the identifier of the trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name. Positive integers can also be used with identifiers. For example, "2XNYS" means every two trading days of New York Stock Exchange.

*rule* can also be a vector of temporal type.

**closed** is a string indicating which boundary of the interval is closed.

-   The default value is 'left' for all values of *rule* except for 'M', 'A', 'Q', 'BM', 'BA', 'BQ', and 'W' which all have a default of 'right'.

-   The default is 'right' if *origin* is 'end' or 'end\_day'.


**label** is a string indicating which boundary is used to label the interval.

-   The default value is 'left' for all values of *rule* except for 'M', 'A', 'Q', 'BM', 'BA', 'BQ', and 'W' which all have a default of 'right'.

-   The default is 'right' if *origin* is 'end' or 'end\_day'.


**origin** is a string or a scalar of the same data type as *X*, indicating the timestamp where the intervals start. It can be 'epoch', start', 'start\_day', 'end', 'end\_day' or a user-defined time object. The default value is 'start\_day'.

-   'epoch': *origin* is 1970-01-01

-   'start': *origin* is the first value of the timeseries

-   'start\_day': *origin* is 00:00 of the first day of the timeseries

-   'end': *origin* is the last value of the timeseries

-   'end\_day': *origin* is 24:00 of the last day of the timeseries


## Details {#details}

Convert *X* to specified frequency. Different from [resample](../r/resample.md), aggregate functions cannot be used in `asfreq`.

## Examples {#examples}

```
index = [2000.01.01, 2000.01.31, 2000.02.15, 2000.02.20, 2000.03.31, 2000.04.16, 2000.05.06, 2000.08.31]
s = indexedSeries(index, 1..8)
s
```

|lable|0|
|-----|---|
|2000.01.01|1|
|2000.01.31|2|
|2000.02.15|3|
|2000.02.20|4|
|2000.03.31|5|
|2000.04.16|6|
|2000.05.06|7|
|2000.08.31|8|

```
s.asfreq("M")
```

|lable|0|
|-----|---|
|2000.01.31|2|
|2000.02.29||
|2000.03.31|5|
|2000.04.30||
|2000.05.31||
|2000.06.30||
|2000.07.31||
|2000.08.31|8|

```
s.asfreq("2M")
```

|lable|0|
|-----|---|
|2000.01.31|2|
|2000.03.31|5|
|2000.05.31||
|2000.07.31||

```
index = [2020.01.01, 2020.01.03, 2020.01.06]
s = indexedSeries(index, 1..3)
s
```

|lable|0|
|-----|---|
|2020.01.01|1|
|2020.01.03|2|
|2020.01.06|3|

```
s.asfreq("D")
```

|lable|0|
|-----|---|
|2020.01.01|1|
|2020.01.02||
|2020.01.03|2|
|2020.01.04||
|2020.01.05||
|2020.01.06|3|

```
s.asfreq("2D")
```

|lable|0|
|-----|---|
|2020.01.01|1|
|2020.01.03|2|
|2020.01.05||

```
index = temporalAdd(2022.10.01 23:30:00,7*(0..8),`m)
s = indexedSeries(index, 3*(0..8))
s.asfreq("8min")
```

|label|col1|
|-----|----|
|2022.10.01T23:28:00||
|2022.10.01T23:36:00||
|2022.10.01T23:44:00|6|
|2022.10.01T23:52:00||
|2022.10.02T00:00:00||
|2022.10.02T00:08:00||
|2022.10.02T00:16:00||
|2022.10.02T00:24:00||

```
s.asfreq(rule=`8min,closed=`right)
```

|label|col1|
|-----|----|
|2022.10.01T23:36:00||
|2022.10.01T23:44:00|6|
|2022.10.01T23:52:00||
|2022.10.02T00:00:00||
|2022.10.02T00:08:00||
|2022.10.02T00:16:00||
|2022.10.02T00:24:00||
|2022.10.02T00:32:00||

```
s.asfreq(rule=`8min,closed=`right,origin=`end)
```

|label|col1|
|-----|----|
|2022.10.01T23:30:00|0|
|2022.10.01T23:38:00||
|2022.10.01T23:46:00||
|2022.10.01T23:54:00||
|2022.10.02T00:02:00||
|2022.10.02T00:10:00||
|2022.10.02T00:18:00||
|2022.10.02T00:26:00|24|

