# appendOrcaStreamTable {#appendOrcaStreamTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`appendOrcaStreamTable(name, data)`

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**data** is a table object containing the data to be inserted.

## Details {#details}

Appends data to an orca stream table.

**Note:** This function does not support regular \(non-Orca\) stream tables.

## Examples {#examples}

Insert the snapshot table into an orca stream table.

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("test")) {
	createCatalog("test")
}
go;
use catalog test

t = table(1..100 as id, 1..100 as value, take(09:29:00.000..13:00:00.000, 100) as timestamp)
g = createStreamGraph("factor")
baseStream = g.source("snapshot",  1024:0, schema(t).colDefs.name, schema(t).colDefs.typeString)
  .reactiveStateEngine([<cumsum(value)>, <timestamp>])
  .setEngineName("rse")
  .buffer("end")
  
g.submit()

appendOrcaStreamTable("snapshot", t)
```

We can verify the inserted data with a SQL query like `SELECT * FROM <catalog>.orca_table.<name>`. The `<catalog>` part is optional—if omitted, the system will use the current catalog automatically.

``` {#codeblock_az5_t1d_3fc}
select * from orca_table.end
```

|cumsum\_value|timestamp|
|-------------|---------|
|1|09:29:00.000|
|3|09:29:00.001|
|6|09:29:00.002|
|10|09:29:00.003|
|15|09:29:00.004|
|21|09:29:00.005|
|28|09:29:00.006|
|36|09:29:00.007|
|45|09:29:00.008|
|55|09:29:00.009|
|…|…|

