# amortizingFixedRateBondDirtyPrice {#amortizingfixedratebonddirtyprice}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`amortizingFixedRateBondDirtyPrice(settlement, maturity, notionals, coupon, yield, calendar, frequency, [basis=1], [convention="Following"])`

## Details {#details}

The `amortizingFixedRateBondDirtyPrice` function calculates the dirty price \(per 100 face value\) of an amortizing fixed-rate bond.

An amortizing fixed-rate bond is a type of bond with a fixed interest rate. This type of bond repays its principal gradually over its term, rather than in a lump sum at maturity. The interest payment for each period decreases over time, as it is calculated based on the remaining unpaid principal balance.

**Return value**: Numeric scalar.

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**settlement** is a DATE scalar or vector indicating the settlement date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**notionals** is a numeric scalar or vector indicating the notional amount for each coupon.

**coupon** is a numeric scalar or vector indicating the annual coupon rate. For example, 0.03 indicates a 3% annual coupon.

**yield** is a numeric scalar or vector indicating the annual yield.

**calendar** is a STRING scalar or vector indicating the trading calendar\(s\). See [Trading Calendar](../../Tutorials/trading_calendar.md) for more information.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**basis** \(optional\) is an INT/STRING scalar or vector indicating the day count basis to use. It can be:

-   0/"Thirty360US": US \(NASD\) 30/360
-   1/"ActualActual": actual/actual
-   2/"Actual360": actual/360
-   3/"Actual365": actual/365
-   4/"Thirty360EU": European 30/360

**convention** \(optional\) is a STRING scalar or vector indicating how cash flows that fall on a non-trading day are treated. The following options are available. Defaults to 'Following'.

-   'Following': The following trading day.
-   'ModifiedFollowing': The following trading day. If that day is in a different month, the preceding trading day is adopted instead.
-   'Preceding': The preceding trading day.
-   'ModifiedPreceding': The preceding trading day. If that day is in a different month, the following trading day is adopted instead.
-   'Unadjusted': Unadjusted.
-   'HalfMonthModifiedFollowing': The following trading day. If that day crosses the mid-month \(15th\) or the end of month, the preceding trading day is adopted instead.
-   'Nearest': The nearest trading day. If both the preceding and following trading days are equally far away, default to following trading day.

## Examples {#examples}

Suppose the purchase date is January 25, 2018, and the maturity date is January 25, 2022. The bond has a principal of 100, an annual coupon rate of 3%, an annual yield of 2.55%, and pays interest annually. Additionally, 50 of the principal is repaid at the 3rd interest payment period. The bond follows the US \(NASD\) 30/360 day-count convention for interest calculations and adheres to the NewYork Stock Exchange \(XNYS\) trading calendar for business day adjustments.

``` {#codeblock_s2l_kp2_c2c}
settlement = 2018.01.25
maturity = 2022.01.25
notionals = [100,100,100,50]
coupon = 0.03
yield = 0.0255
calendar = `XNYS
frequency = 1
basis = 0
res = amortizingFixedRateBondDirtyPrice(settlement, maturity, notionals, coupon, yield, calendar, frequency, basis)
res;
// 101.4874025388439
```

