# adfuller {#adfuller}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`adfuller(X, [maxLag], [regression="c"], [autoLag="aic"], [store=false], [regResults=false])`

## Arguments {#arguments}

**X** is a numeric vector indicating the time series data to test. The elements in X cannot be all identical, and null values are not supported.

**maxlag** \(optional\) is a non-negative integer indicating the maximum lag which is included in test. The default value is `12*(nobs/100)^{1/4}` where nobs is the number of observations.

**regression** \(optional\) is a string indicating the constant and trend order to include in regression. It can be:

-   "c" : constant only \(default\).

-   "ct" : constant and trend.

-   "ctt" : constant, and linear and quadratic trend.

-   "n" : no constant, no trend.


**autoLag** \(optional\) is a string indicating the method to use when automatically determining the lag length among the values 0, 1, …, *maxlag*. It can be:

-   "aic": The number of lags is chosen to minimize the Akaike information criterion.

-   "bic": The number of lags is chosen to minimize the Bayesian information criterion.

-   "tstat": Start with *maxLag* and drops a lag until the t-statistic on the last lag length is significant using a 5%-sized test.

-   "max": The number of included lags is set to *maxLag*.


**store** \(optional\) is a Boolean value. If set to true, the regression result is returned additionally to the adf statistic. The default value is false.

**regResults** \(optional\) is a Boolean value. If set to true, the full regression results are returned. The default value is false.

## Details {#details}

Perform Augmented Dickey-Fuller unit root test. It can be used to test for a unit root in a univariate process in the presence of serial correlation.

**Return value**: A dictionary containing the following keys

-   adfStat: A floating-point scalar indicating the test statistic.

-   pValue: A floating-point scalar indicating the MacKinnon's approximate p-value based on MacKinnon \(1994, 2010\).

-   usedLag: An integer indicating the number of lags used.

-   nobs: An integer indicating the number of observations used for the ADF regression and calculation of the critical values.

-   criticalValues: A dictionary containing the critical values for the test statistic at the 1 %, 5 %, and 10 % levels.

-   icBest: A floating-point scalar indicating the maximized information criterion if *autoLag*is not max.

-   resultStore: A dictionary with results when *regResults*or *store*is set to true.


## Examples {#examples}

``` {#codeblock_w2f_rf3_31c}
data = 234 267 289 301 312 323 334 345 356 367
adfuller(data);
```

A dictionary is returned:

``` {#codeblock_br5_rf3_31c}
adfStat->-4.34190584894534
pValue->0.00037562619202430314
criticalValues->[-4.473135048010974,-3.2898806035665293,-2.772382345679012]
usedLag->0
nobs->9
icBest->-195.23465793624445
```

